/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class XmlRpcDateTimeFormat
extends Format {
    private static final long serialVersionUID = -8008230377361175138L;

    protected abstract TimeZone getTimeZone();

    private int parseInt(String pString, int pOffset, StringBuffer pDigits, int pMaxDigits) {
        char c;
        int length = pString.length();
        pDigits.setLength(0);
        while (pMaxDigits-- > 0 && pOffset < length && Character.isDigit(c = pString.charAt(pOffset))) {
            pDigits.append(c);
            ++pOffset;
        }
        return pOffset;
    }

    @Override
    public Object parseObject(String pString, ParsePosition pParsePosition) {
        if (pString == null) {
            throw new NullPointerException("The String argument must not be null.");
        }
        if (pParsePosition == null) {
            throw new NullPointerException("The ParsePosition argument must not be null.");
        }
        int offset = pParsePosition.getIndex();
        int length = pString.length();
        StringBuffer digits = new StringBuffer();
        offset = this.parseInt(pString, offset, digits, 4);
        if (digits.length() < 4) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int year = Integer.parseInt(digits.toString());
        offset = this.parseInt(pString, offset, digits, 2);
        if (digits.length() != 2) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int month = Integer.parseInt(digits.toString());
        offset = this.parseInt(pString, offset, digits, 2);
        if (digits.length() != 2) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int mday = Integer.parseInt(digits.toString());
        if (offset < length && pString.charAt(offset) == 'T') {
            ++offset;
        } else {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        offset = this.parseInt(pString, offset, digits, 2);
        if (digits.length() != 2) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int hour = Integer.parseInt(digits.toString());
        if (offset < length && pString.charAt(offset) == ':') {
            ++offset;
        } else {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        offset = this.parseInt(pString, offset, digits, 2);
        if (digits.length() != 2) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int minute = Integer.parseInt(digits.toString());
        if (offset < length && pString.charAt(offset) == ':') {
            ++offset;
        } else {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        offset = this.parseInt(pString, offset, digits, 2);
        if (digits.length() != 2) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
        int second = Integer.parseInt(digits.toString());
        Calendar cal = Calendar.getInstance(this.getTimeZone());
        cal.set(year, month - 1, mday, hour, minute, second);
        cal.set(14, 0);
        pParsePosition.setIndex(offset);
        return cal;
    }

    private void append(StringBuffer pBuffer, int pNum, int pMinLen) {
        String s = Integer.toString(pNum);
        for (int i = s.length(); i < pMinLen; ++i) {
            pBuffer.append('0');
        }
        pBuffer.append(s);
    }

    @Override
    public StringBuffer format(Object pCalendar, StringBuffer pBuffer, FieldPosition pPos) {
        if (pCalendar == null) {
            throw new NullPointerException("The Calendar argument must not be null.");
        }
        if (pBuffer == null) {
            throw new NullPointerException("The StringBuffer argument must not be null.");
        }
        if (pPos == null) {
            throw new NullPointerException("The FieldPosition argument must not be null.");
        }
        Calendar cal = (Calendar)pCalendar;
        int year = cal.get(1);
        this.append(pBuffer, year, 4);
        this.append(pBuffer, cal.get(2) + 1, 2);
        this.append(pBuffer, cal.get(5), 2);
        pBuffer.append('T');
        this.append(pBuffer, cal.get(11), 2);
        pBuffer.append(':');
        this.append(pBuffer, cal.get(12), 2);
        pBuffer.append(':');
        this.append(pBuffer, cal.get(13), 2);
        return pBuffer;
    }
}

