/*
 * Decompiled with CFR 0.152.
 */
package com.ni.rio;

import com.ni.rio.NiRioConstants;
import com.ni.rio.NiRioStatus;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.ptr.IntByReference;

public class NiFpga
implements NiRioConstants {
    private static final Function configFifoFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_ConfigureFifo");
    private static final Function startFifoFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_StartFifo");
    private static final Function stopFifoFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_StopFifo");
    private static final Function readFifoU32Fn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_ReadFifoU32");
    private static final Function writeU32Fn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_WriteU32");
    private static IntByReference readValue = new IntByReference(0);
    private static final Function readU32Fn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_ReadU32");
    private static final Function reserveIrqContextFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_ReserveIrqContext");
    private static final Function unreserveIrqContextFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_UnreserveIrqContext");
    private static IntByReference irqsAsserted = new IntByReference(0);
    private static final Function waitOnIrqsFn = NativeLibrary.getDefaultInstance().getFunction("NiFpga_WaitOnIrqs");

    public static void configureFifo(int hClient, int channel, int fifoDepthInElements, NiRioStatus status) {
        NiFpga.mergeStatus(status, configFifoFn.call3(hClient, channel, fifoDepthInElements));
    }

    public static void startFifo(int hClient, int channel, NiRioStatus status) {
        NiFpga.mergeStatus(status, startFifoFn.call2(hClient, channel));
    }

    public static void stopFifo(int hClient, int channel, NiRioStatus status) {
        NiFpga.mergeStatus(status, stopFifoFn.call2(hClient, channel));
    }

    public static void readFifoU32(int hClient, int channel, Pointer buf, int num, int timeout, IntByReference remaining, NiRioStatus status) {
        NiFpga.mergeStatus(status, readFifoU32Fn.call6(hClient, channel, buf.address().toUWord().toPrimitive(), num, timeout, remaining.getPointer().address().toUWord().toPrimitive()));
    }

    static void mergeStatus(NiRioStatus statusA, int statusB) {
        statusA.setStatus(statusB);
    }

    public static void writeU32(int hClient, int offset, int value, NiRioStatus status) {
        NiFpga.mergeStatus(status, writeU32Fn.call3(hClient, offset, value));
    }

    public static synchronized int readU32(int hClient, int offset, NiRioStatus status) {
        NiFpga.mergeStatus(status, readU32Fn.call3(hClient, offset, readValue.getPointer()));
        return readValue.getValue();
    }

    public static void reserveIrqContext(int hClient, IntByReference context, NiRioStatus status) {
        NiFpga.mergeStatus(status, reserveIrqContextFn.call2(hClient, context.getPointer().address().toUWord().toPrimitive()));
    }

    public static void unreserveIrqContext(int hClient, IntByReference context, NiRioStatus status) {
        NiFpga.mergeStatus(status, unreserveIrqContextFn.call2(hClient, context.getValue()));
    }

    public static synchronized int waitOnIrqs(int hClient, IntByReference context, int irqs, int timeout, NiRioStatus status) {
        irqsAsserted.setValue(0);
        NiFpga.mergeStatus(status, waitOnIrqsFn.call6(hClient, context.getValue(), irqs, timeout, irqsAsserted.getPointer().address().toUWord().toPrimitive(), 0));
        return irqsAsserted.getValue();
    }

    private NiFpga() {
    }
}

