/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.dserror;

import com.sun.cldc.jna.Pointer;
import edu.wpi.first.wpilibj.communication.FRCControl;
import java.io.IOException;
import java.io.OutputStream;

class DSErrorOutputStream
extends OutputStream {
    static final int DEFAULT_BUFFER_SIZE = 512;
    private Pointer errorBuffer = new Pointer(512);
    private int index = 0;
    private boolean errorOccurred;

    DSErrorOutputStream() {
    }

    public synchronized void write(int b) throws IOException {
        if (this.errorOccurred) {
            return;
        }
        try {
            if (this.errorBuffer == null) {
                throw new IllegalStateException("DSErrorOutputStream is closed");
            }
            if (this.index >= this.errorBuffer.getSize()) {
                this.flush();
            }
            if (b == 10 && this.index != 0) {
                this.flush();
            } else {
                this.errorBuffer.setByte((long)this.index++, (byte)b);
            }
        }
        catch (Throwable e) {
            this.errorOccurred = true;
            throw new RuntimeException("Squashing exception in error stream writer: " + e);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.errorBuffer == null) {
            throw new IllegalStateException("DSErrorOutputStream is closed");
        }
        if (this.index > 0) {
            FRCControl.setErrorData(this.errorBuffer, this.index, 100);
            this.index = 0;
        }
    }

    public synchronized void close() {
        if (this.errorBuffer != null) {
            this.index = 0;
            this.errorBuffer.free();
            this.errorBuffer = null;
        }
    }
}

