/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;

public class ADXL345_I2C
extends SensorBase {
    private static final byte kAddress = 58;
    private static final byte kPowerCtlRegister = 45;
    private static final byte kDataFormatRegister = 49;
    private static final byte kDataRegister = 50;
    private static final double kGsPerLSB = 0.00390625;
    private static final byte kPowerCtl_Link = 32;
    private static final byte kPowerCtl_AutoSleep = 16;
    private static final byte kPowerCtl_Measure = 8;
    private static final byte kPowerCtl_Sleep = 4;
    private static final byte kDataFormat_SelfTest = -128;
    private static final byte kDataFormat_SPI = 64;
    private static final byte kDataFormat_IntInvert = 32;
    private static final byte kDataFormat_FullRes = 8;
    private static final byte kDataFormat_Justify = 4;
    private I2C m_i2c;

    public ADXL345_I2C(int moduleNumber, DataFormat_Range range) {
        DigitalModule module = DigitalModule.getInstance(moduleNumber);
        this.m_i2c = module.getI2C(58);
        this.m_i2c.write(45, 8);
        this.m_i2c.write(49, 8 | range.value);
        UsageReporting.report(5, 2, moduleNumber - 1);
    }

    public double getAcceleration(Axes axis) {
        byte[] rawAccel = new byte[2];
        this.m_i2c.read(50 + axis.value, rawAccel.length, rawAccel);
        return this.accelFromBytes(rawAccel[0], rawAccel[1]);
    }

    private double accelFromBytes(byte first, byte second) {
        short tempLow = (short)(first & 0xFF);
        short tempHigh = (short)(second << 8 & 0xFF00);
        return (double)(tempLow | tempHigh) * 0.00390625;
    }

    public AllAxes getAccelerations() {
        AllAxes data = new AllAxes();
        byte[] rawData = new byte[6];
        this.m_i2c.read(50, rawData.length, rawData);
        data.XAxis = this.accelFromBytes(rawData[0], rawData[1]);
        data.YAxis = this.accelFromBytes(rawData[2], rawData[3]);
        data.ZAxis = this.accelFromBytes(rawData[4], rawData[5]);
        return data;
    }

    public static class AllAxes {
        public double XAxis;
        public double YAxis;
        public double ZAxis;
    }

    public static class Axes {
        public final byte value;
        static final byte kX_val = 0;
        static final byte kY_val = 2;
        static final byte kZ_val = 4;
        public static final Axes kX = new Axes(0);
        public static final Axes kY = new Axes(2);
        public static final Axes kZ = new Axes(4);

        private Axes(byte value) {
            this.value = value;
        }
    }

    public static class DataFormat_Range {
        public final byte value;
        static final byte k2G_val = 0;
        static final byte k4G_val = 1;
        static final byte k8G_val = 2;
        static final byte k16G_val = 3;
        public static final DataFormat_Range k2G = new DataFormat_Range(0);
        public static final DataFormat_Range k4G = new DataFormat_Range(1);
        public static final DataFormat_Range k8G = new DataFormat_Range(2);
        public static final DataFormat_Range k16G = new DataFormat_Range(3);

        private DataFormat_Range(byte value) {
            this.value = value;
        }
    }
}

