/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalOutput;
import edu.wpi.first.wpilibj.SPIDevice;
import edu.wpi.first.wpilibj.SensorBase;

public class ADXL345_SPI
extends SensorBase {
    private static final int kPowerCtlRegister = 45;
    private static final int kDataFormatRegister = 49;
    private static final int kDataRegister = 50;
    private static final double kGsPerLSB = 0.00390625;
    private static final int kAddress_Read = 128;
    private static final int kAddress_MultiByte = 64;
    private static final int kPowerCtl_Link = 32;
    private static final int kPowerCtl_AutoSleep = 16;
    private static final int kPowerCtl_Measure = 8;
    private static final int kPowerCtl_Sleep = 4;
    private static final int kDataFormat_SelfTest = 128;
    private static final int kDataFormat_SPI = 64;
    private static final int kDataFormat_IntInvert = 32;
    private static final int kDataFormat_FullRes = 8;
    private static final int kDataFormat_Justify = 4;
    private SPIDevice spi;

    public ADXL345_SPI(DigitalOutput clk, DigitalOutput mosi, DigitalInput miso, DigitalOutput cs, DataFormat_Range range) {
        this.spi = new SPIDevice(clk, mosi, miso, cs, true);
        this.init(range);
    }

    public ADXL345_SPI(int slot, int clkChannel, int mosiChannel, int misoChannel, int csChannel, DataFormat_Range range) {
        this.spi = new SPIDevice(slot, clkChannel, mosiChannel, misoChannel, csChannel, true);
        this.init(range);
    }

    public ADXL345_SPI(DigitalOutput cs, DataFormat_Range range) {
        this.spi = new SPIDevice(cs, true);
        this.init(range);
    }

    public ADXL345_SPI(int slot, int csChannel, DataFormat_Range range) {
        this.spi = new SPIDevice(slot, csChannel, true);
        this.init(range);
    }

    public void free() {
        this.spi.free();
    }

    private void init(DataFormat_Range range) {
        this.spi.setBitOrder(true);
        this.spi.setClockPolarity(true);
        this.spi.setDataOnTrailing(false);
        this.spi.transfer(11528L, 16);
        this.spi.transfer(0x3108 | range.value, 16);
    }

    public double getAcceleration(Axes axis) {
        long rawAccelLong = this.spi.transfer(242 + axis.value << 16, 24);
        return this.accelFromBytes(rawAccelLong);
    }

    private double accelFromBytes(long value) {
        short rawAccel = (short)(value & 0xFFL);
        rawAccel = (short)(rawAccel << 8);
        rawAccel = (short)((long)rawAccel | value >> 8 & 0xFFL);
        return (double)rawAccel * 0.00390625;
    }

    public AllAxes getAccelerations() {
        AllAxes data = new AllAxes();
        long[] rawData = this.spi.transfer(new long[]{242L, 0L, 0L, 0L}, new int[]{8, 16, 16, 16});
        data.XAxis = this.accelFromBytes(rawData[1]);
        data.YAxis = this.accelFromBytes(rawData[2]);
        data.ZAxis = this.accelFromBytes(rawData[3]);
        return data;
    }

    public static class AllAxes {
        public double XAxis;
        public double YAxis;
        public double ZAxis;
    }

    public static class Axes {
        public final byte value;
        static final byte kX_val = 0;
        static final byte kY_val = 2;
        static final byte kZ_val = 4;
        public static final Axes kX = new Axes(0);
        public static final Axes kY = new Axes(2);
        public static final Axes kZ = new Axes(4);

        private Axes(byte value) {
            this.value = value;
        }
    }

    public static class DataFormat_Range {
        public final byte value;
        static final byte k2G_val = 0;
        static final byte k4G_val = 1;
        static final byte k8G_val = 2;
        static final byte k16G_val = 3;
        public static final DataFormat_Range k2G = new DataFormat_Range(0);
        public static final DataFormat_Range k4G = new DataFormat_Range(1);
        public static final DataFormat_Range k8G = new DataFormat_Range(2);
        public static final DataFormat_Range k16G = new DataFormat_Range(3);

        private DataFormat_Range(byte value) {
            this.value = value;
        }
    }
}

