/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.tables.ITable;

public class Accelerometer
extends SensorBase
implements PIDSource,
ISensor,
LiveWindowSendable {
    private AnalogChannel m_analogChannel;
    private double m_voltsPerG = 1.0;
    private double m_zeroGVoltage = 2.5;
    private boolean m_allocatedChannel;
    private ITable m_table;

    private void initAccelerometer() {
        UsageReporting.report(4, this.m_analogChannel.getChannel(), this.m_analogChannel.getModuleNumber() - 1);
        LiveWindow.addSensor("Accelerometer", this.m_analogChannel.getModuleNumber(), this.m_analogChannel.getChannel(), this);
    }

    public Accelerometer(int channel) {
        this.m_allocatedChannel = true;
        this.m_analogChannel = new AnalogChannel(channel);
        this.initAccelerometer();
    }

    public Accelerometer(int slot, int channel) {
        this.m_allocatedChannel = true;
        this.m_analogChannel = new AnalogChannel(slot, channel);
        this.initAccelerometer();
    }

    public Accelerometer(AnalogChannel channel) {
        this.m_allocatedChannel = false;
        if (channel == null) {
            throw new NullPointerException("Analog Channel given was null");
        }
        this.m_analogChannel = channel;
        this.initAccelerometer();
    }

    public void free() {
        if (this.m_analogChannel != null && this.m_allocatedChannel) {
            this.m_analogChannel.free();
        }
        this.m_analogChannel = null;
    }

    public double getAcceleration() {
        return (this.m_analogChannel.getAverageVoltage() - this.m_zeroGVoltage) / this.m_voltsPerG;
    }

    public void setSensitivity(double sensitivity) {
        this.m_voltsPerG = sensitivity;
    }

    public void setZero(double zero) {
        this.m_zeroGVoltage = zero;
    }

    public double pidGet() {
        return this.getAcceleration();
    }

    public String getSmartDashboardType() {
        return "Accelerometer";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAcceleration());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }
}

