/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.interfaces.Potentiometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class AnalogPotentiometer
implements Potentiometer,
LiveWindowSendable {
    private int m_module;
    private int m_channel;
    private double m_scale;
    private double m_offset;
    private AnalogChannel m_analog_channel;
    private ITable m_table;

    private void initPot(int slot, int channel, double scale, double offset) {
        this.m_module = slot;
        this.m_channel = channel;
        this.m_scale = scale;
        this.m_offset = offset;
        this.m_analog_channel = new AnalogChannel(slot, channel);
    }

    public AnalogPotentiometer(int slot, int channel, double scale, double offset) {
        this.initPot(slot, channel, scale, offset);
    }

    public AnalogPotentiometer(int channel, double scale, double offset) {
        this.initPot(1, channel, scale, offset);
    }

    public AnalogPotentiometer(int channel, double scale) {
        this.initPot(1, channel, scale, 0.0);
    }

    public AnalogPotentiometer(int channel) {
        this.initPot(1, channel, 1.0, 0.0);
    }

    public double get() {
        return this.m_analog_channel.getVoltage() * this.m_scale + this.m_offset;
    }

    public double pidGet() {
        return this.get();
    }

    public String getSmartDashboardType() {
        return "Analog Input";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }
}

