/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogTrigger;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.fpga.tAnalogTrigger;
import edu.wpi.first.wpilibj.parsing.IInputOutput;

public class AnalogTriggerOutput
extends DigitalSource
implements IInputOutput {
    private AnalogTrigger m_trigger;
    private Type m_outputType;

    public AnalogTriggerOutput(AnalogTrigger trigger, Type outputType) {
        if (trigger == null) {
            throw new NullPointerException("Analog Trigger given was null");
        }
        this.m_trigger = trigger;
        this.m_outputType = outputType;
        UsageReporting.report(8, trigger.getIndex(), outputType.value);
    }

    public void free() {
    }

    public boolean get() {
        switch (this.m_outputType.value) {
            case 0: {
                return tAnalogTrigger.readOutput_InHysteresis((byte)this.m_trigger.m_index);
            }
            case 1: {
                return tAnalogTrigger.readOutput_OverLimit((byte)this.m_trigger.m_index);
            }
            case 2: 
            case 3: {
                throw new AnalogTriggerOutputException("Cannot get the state of the analog trigger output if it is configured for a rising or falling edge");
            }
        }
        return false;
    }

    public int getChannelForRouting() {
        return (this.m_trigger.m_index << 2) + this.m_outputType.value;
    }

    public int getModuleForRouting() {
        return this.m_trigger.m_index >> 2;
    }

    public boolean getAnalogTriggerForRouting() {
        return true;
    }

    public static class Type {
        public final int value;
        static final int kInWindow_val = 0;
        static final int kTypeState_val = 1;
        static final int kRisingPulse_val = 2;
        static final int kFallingPulse_val = 3;
        public static final Type kInWindow = new Type(0);
        public static final Type kTypeState = new Type(1);
        public static final Type kRisingPulse = new Type(2);
        public static final Type kFallingPulse = new Type(3);

        private Type(int value) {
            this.value = value;
        }
    }

    public class AnalogTriggerOutputException
    extends RuntimeException {
        public AnalogTriggerOutputException(String message) {
            super(message);
        }
    }
}

