/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.can.CANJaguarVersionException;
import edu.wpi.first.wpilibj.can.CANTimeoutException;
import edu.wpi.first.wpilibj.can.JaguarCANDriver;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class CANJaguar
implements MotorSafety,
PIDOutput,
SpeedController,
LiveWindowSendable {
    public static final int kControllerRate = 1000;
    public static final double kApproxBusVoltage = 12.0;
    private final Object m_transactionMutex = new Object();
    private byte m_deviceNumber;
    private ControlMode m_controlMode;
    private double m_maxOutputVoltage;
    private MotorSafetyHelper m_safetyHelper;
    private static final byte[] kNoData = new byte[0];
    private static final int kFullMessageIDMask = 536870848;
    private static final byte[] sendTrustedDataBuffer = new byte[8];
    private ITable m_table;
    private ITableListener m_table_listener;

    private static final int swap16(int x) {
        return x >>> 8 & 0xFF | x << 8 & 0xFF00;
    }

    private static final long swap32(long x) {
        return x >> 24 & 0xFFL | x >> 8 & 0xFF00L | x << 8 & 0xFF0000L | x << 24 & 0xFFFFFFFFFF000000L;
    }

    private static final int swap16(int x, byte[] buffer) {
        buffer[0] = (byte)x;
        buffer[1] = (byte)(x >>> 8 & 0xFF);
        return x >>> 8 & 0xFF | x << 8 & 0xFF00;
    }

    private static final long swap32(long x, byte[] buffer) {
        buffer[0] = (byte)x;
        buffer[1] = (byte)(x >>> 8 & 0xFFL);
        buffer[2] = (byte)(x >>> 16 & 0xFFL);
        buffer[3] = (byte)(x >>> 24 & 0xFFL);
        return x >> 24 & 0xFFL | x >> 8 & 0xFF00L | x << 8 & 0xFF0000L | x << 24 & 0xFFFFFFFFFF000000L;
    }

    private static final int swap16(byte[] buffer) {
        return buffer[1] >>> 8 & 0xFF | buffer[0] << 8 & 0xFF00;
    }

    private static final long swap32(byte[] buffer) {
        return buffer[3] >> 24 & 0xFF | buffer[2] >> 8 & 0xFF00 | buffer[1] << 8 & 0xFF0000 | buffer[0] << 24 & 0xFF000000;
    }

    private static final void pack16(short data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data & 0xFF);
        buffer[offset + 1] = (byte)(data >>> 8 & 0xFF);
    }

    private static final void pack32(int data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data & 0xFF);
        buffer[offset + 1] = (byte)(data >>> 8 & 0xFF);
        buffer[offset + 2] = (byte)(data >>> 16 & 0xFF);
        buffer[offset + 3] = (byte)(data >>> 24 & 0xFF);
    }

    private static final short unpack16(byte[] buffer, int offset) {
        return (short)(buffer[offset] & 0xFF | (short)(buffer[offset + 1] << 8) & 0xFF00);
    }

    private static final int unpack32(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | buffer[offset + 1] << 8 & 0xFF00 | buffer[offset + 2] << 16 & 0xFF0000 | buffer[offset + 3] << 24 & 0xFF000000;
    }

    private void initCANJaguar() throws CANTimeoutException {
        if (this.m_deviceNumber < 1 || this.m_deviceNumber > 63) {
            throw new RuntimeException("Invalid CAN device number \"" + this.m_deviceNumber + "\" - must be between 1 and 63.");
        }
        int fwVer = this.getFirmwareVersion();
        if (fwVer >= 3330 || fwVer < 101) {
            throw new CANJaguarVersionException(this.m_deviceNumber, fwVer);
        }
        switch (this.m_controlMode.value) {
            case 0: 
            case 4: {
                this.enableControl();
                break;
            }
        }
        this.m_safetyHelper = new MotorSafetyHelper(this);
        UsageReporting.report(9, this.m_deviceNumber, this.m_controlMode.value);
        LiveWindow.addActuator("CANJaguar", this.m_deviceNumber, 0, this);
    }

    public CANJaguar(int deviceNumber) throws CANTimeoutException {
        this.m_deviceNumber = (byte)deviceNumber;
        this.m_controlMode = ControlMode.kPercentVbus;
        this.m_maxOutputVoltage = 12.0;
        this.initCANJaguar();
    }

    public CANJaguar(int deviceNumber, ControlMode controlMode) throws CANTimeoutException {
        this.m_deviceNumber = (byte)deviceNumber;
        this.m_controlMode = controlMode;
        this.m_maxOutputVoltage = 12.0;
        this.initCANJaguar();
    }

    public void setX(double outputValue) throws CANTimeoutException {
        this.setX(outputValue, (byte)0);
    }

    public void set(double outputValue) {
        this.set(outputValue, (byte)0);
    }

    public void setX(double outputValue, byte syncGroup) throws CANTimeoutException {
        int messageID = 0;
        byte[] dataBuffer = new byte[8];
        int dataSize = 0;
        if (!this.m_safetyHelper.isAlive()) {
            this.enableControl();
        }
        switch (this.m_controlMode.value) {
            case 0: {
                messageID = 33685824;
                if (outputValue > 1.0) {
                    outputValue = 1.0;
                }
                if (outputValue < -1.0) {
                    outputValue = -1.0;
                }
                this.packPercentage(dataBuffer, outputValue);
                dataSize = 2;
                break;
            }
            case 2: {
                messageID = 0x2020600;
                dataSize = this.packFXP16_16(dataBuffer, outputValue);
                break;
            }
            case 3: {
                messageID = 0x2020E00;
                dataSize = this.packFXP16_16(dataBuffer, outputValue);
                break;
            }
            case 1: {
                messageID = 33690048;
                dataSize = this.packFXP8_8(dataBuffer, outputValue);
                break;
            }
            case 4: {
                messageID = 33687936;
                dataSize = this.packFXP8_8(dataBuffer, outputValue);
                break;
            }
            default: {
                return;
            }
        }
        if (syncGroup != 0) {
            dataBuffer[dataSize] = syncGroup;
            dataSize = (byte)(dataSize + 1);
        }
        this.setTransaction(messageID, dataBuffer, (byte)dataSize);
        this.m_safetyHelper.feed();
    }

    public void set(double outputValue, byte syncGroup) {
        try {
            this.setX(outputValue, syncGroup);
        }
        catch (CANTimeoutException e) {
            // empty catch block
        }
    }

    public double getX() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: {
                dataSize = this.getTransaction(0x2020080, dataBuffer);
                if (dataSize != 2) break;
                return this.unpackPercentage(dataBuffer);
            }
            case 2: {
                dataSize = this.getTransaction(33686656, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 3: {
                dataSize = this.getTransaction(33688704, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 1: {
                dataSize = this.getTransaction(33689728, dataBuffer);
                if (dataSize != 2) break;
                return this.unpackFXP8_8(dataBuffer);
            }
            case 4: {
                dataSize = this.getTransaction(0x2020880, dataBuffer);
                if (dataSize != 2) break;
                return this.unpackFXP8_8(dataBuffer);
            }
        }
        return 0.0;
    }

    public double get() {
        try {
            return this.getX();
        }
        catch (CANTimeoutException e) {
            return 0.0;
        }
    }

    public void disable() {
        try {
            this.disableControl();
        }
        catch (CANTimeoutException cANTimeoutException) {
            // empty catch block
        }
    }

    public void pidWrite(double output) {
        if (this.m_controlMode == ControlMode.kPercentVbus) {
            this.set(output);
        }
    }

    byte packPercentage(byte[] buffer, double value) {
        short intValue = (short)(value * 32767.0);
        CANJaguar.swap16(intValue, buffer);
        return 2;
    }

    byte packFXP8_8(byte[] buffer, double value) {
        short intValue = (short)(value * 256.0);
        CANJaguar.swap16(intValue, buffer);
        return 2;
    }

    byte packFXP16_16(byte[] buffer, double value) {
        int intValue = (int)(value * 65536.0);
        CANJaguar.swap32(intValue, buffer);
        return 4;
    }

    byte packINT16(byte[] buffer, short value) {
        CANJaguar.swap16(value, buffer);
        return 2;
    }

    byte packINT32(byte[] buffer, int value) {
        CANJaguar.swap32(value, buffer);
        return 4;
    }

    double unpackPercentage(byte[] buffer) {
        return (double)CANJaguar.unpack16(buffer, 0) / 32767.0;
    }

    double unpackFXP8_8(byte[] buffer) {
        return (double)CANJaguar.unpack16(buffer, 0) / 256.0;
    }

    double unpackFXP16_16(byte[] buffer) {
        return (double)CANJaguar.unpack32(buffer, 0) / 65536.0;
    }

    int unpackINT16(byte[] buffer) {
        return CANJaguar.unpack16(buffer, 0);
    }

    long unpackINT32(byte[] buffer) {
        return CANJaguar.unpack32(buffer, 0);
    }

    protected static void sendMessage(int messageID, byte[] data, int dataSize) throws CANTimeoutException {
        int[] kTrustedMessages = new int[]{0x2020100, 33685824, 33686976, 0x2020600, 33687872, 33687936, 33689024, 0x2020E00, 33689984, 33690048};
        for (int i = 0; i < kTrustedMessages.length; i = (int)((byte)(i + 1))) {
            if ((0x1FFFFFC0 & messageID) != kTrustedMessages[i]) continue;
            CANJaguar.sendTrustedDataBuffer[0] = 0;
            CANJaguar.sendTrustedDataBuffer[1] = 0;
            if (dataSize > 6) {
                throw new RuntimeException("CAN message has too much data.");
            }
            for (int j = 0; j < dataSize; j = (int)((byte)(j + 1))) {
                CANJaguar.sendTrustedDataBuffer[j + 2] = data[j];
            }
            JaguarCANDriver.sendMessage(messageID, sendTrustedDataBuffer, dataSize + 2);
            return;
        }
        JaguarCANDriver.sendMessage(messageID, data, dataSize);
    }

    protected static byte receiveMessage(int messageID, byte[] data, double timeout) throws CANTimeoutException {
        JaguarCANDriver canDriver = new JaguarCANDriver();
        byte dataSize = canDriver.receiveMessage(messageID, data, timeout);
        return dataSize;
    }

    protected static byte receiveMessage(int messageID, byte[] data) throws CANTimeoutException {
        return CANJaguar.receiveMessage(messageID, data, 0.01);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte setTransaction(int messageID, byte[] data, byte dataSize) throws CANTimeoutException {
        int ackMessageID = 0x2022000 | this.m_deviceNumber;
        Object object = this.m_transactionMutex;
        synchronized (object) {
            try {
                CANJaguar.receiveMessage(ackMessageID, kNoData, 0.0);
            }
            catch (CANTimeoutException e) {
                // empty catch block
            }
            CANJaguar.sendMessage(messageID | this.m_deviceNumber, data, dataSize);
            dataSize = CANJaguar.receiveMessage(ackMessageID, kNoData);
        }
        return dataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte getTransaction(int messageID, byte[] data) throws CANTimeoutException {
        int targetedMessageID = messageID | this.m_deviceNumber;
        byte dataSize = 0;
        Object object = this.m_transactionMutex;
        synchronized (object) {
            CANJaguar.sendMessage(targetedMessageID, kNoData, 0);
            dataSize = CANJaguar.receiveMessage(targetedMessageID &= 0x1FFFFFFF, data);
        }
        return dataSize;
    }

    public void setSpeedReference(SpeedReference reference) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        dataBuffer[0] = reference.value;
        this.setTransaction(33686912, dataBuffer, (byte)1);
    }

    public SpeedReference getSpeedReference() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        dataSize = this.getTransaction(33686912, dataBuffer);
        if (dataSize == 1) {
            switch (dataBuffer[0]) {
                case 0: {
                    return SpeedReference.kEncoder;
                }
                case 2: {
                    return SpeedReference.kInvEncoder;
                }
                case 3: {
                    return SpeedReference.kQuadEncoder;
                }
                case -1: {
                    return SpeedReference.kNone;
                }
            }
        }
        return SpeedReference.kNone;
    }

    public void setPositionReference(PositionReference reference) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        dataBuffer[0] = reference.value;
        this.setTransaction(33688960, dataBuffer, (byte)1);
    }

    public PositionReference getPositionReference() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        dataSize = this.getTransaction(33688960, dataBuffer);
        if (dataSize == 1) {
            switch (dataBuffer[0]) {
                case 1: {
                    return PositionReference.kPotentiometer;
                }
                case 0: {
                    return PositionReference.kQuadEncoder;
                }
                case -1: {
                    return PositionReference.kNone;
                }
            }
        }
        return PositionReference.kNone;
    }

    public void setPID(double p, double i, double d) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        switch (this.m_controlMode.value) {
            case 0: 
            case 4: {
                break;
            }
            case 2: {
                byte dataSize = this.packFXP16_16(dataBuffer, p);
                this.setTransaction(33686720, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, i);
                this.setTransaction(0x2020500, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, d);
                this.setTransaction(33686848, dataBuffer, dataSize);
                break;
            }
            case 3: {
                byte dataSize = this.packFXP16_16(dataBuffer, p);
                this.setTransaction(0x2020CC0, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, i);
                this.setTransaction(0x2020D00, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, d);
                this.setTransaction(33688896, dataBuffer, dataSize);
                break;
            }
            case 1: {
                byte dataSize = this.packFXP16_16(dataBuffer, p);
                this.setTransaction(33689792, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, i);
                this.setTransaction(0x2021100, dataBuffer, dataSize);
                dataSize = this.packFXP16_16(dataBuffer, d);
                this.setTransaction(33689920, dataBuffer, dataSize);
            }
        }
    }

    public double getP() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: 
            case 4: {
                break;
            }
            case 2: {
                dataSize = this.getTransaction(33686720, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 3: {
                dataSize = this.getTransaction(0x2020CC0, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 1: {
                dataSize = this.getTransaction(33689792, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
        }
        return 0.0;
    }

    public double getI() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: 
            case 4: {
                break;
            }
            case 2: {
                dataSize = this.getTransaction(0x2020500, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 3: {
                dataSize = this.getTransaction(0x2020D00, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 1: {
                dataSize = this.getTransaction(0x2021100, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
        }
        return 0.0;
    }

    public double getD() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: 
            case 4: {
                break;
            }
            case 2: {
                dataSize = this.getTransaction(33686848, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 3: {
                dataSize = this.getTransaction(33688896, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
            case 1: {
                dataSize = this.getTransaction(33689920, dataBuffer);
                if (dataSize != 4) break;
                return this.unpackFXP16_16(dataBuffer);
            }
        }
        return 0.0;
    }

    public void enableControl() throws CANTimeoutException {
        this.enableControl(0.0);
    }

    public void enableControl(double encoderInitialPosition) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: {
                this.setTransaction(0x2020100, dataBuffer, dataSize);
                break;
            }
            case 2: {
                this.setTransaction(33686976, dataBuffer, dataSize);
                break;
            }
            case 3: {
                dataSize = this.packFXP16_16(dataBuffer, encoderInitialPosition);
                this.setTransaction(33689024, dataBuffer, dataSize);
                break;
            }
            case 1: {
                this.setTransaction(33689984, dataBuffer, dataSize);
                break;
            }
            case 4: {
                this.setTransaction(33687872, dataBuffer, dataSize);
            }
        }
    }

    public void disableControl() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        switch (this.m_controlMode.value) {
            case 0: {
                this.setTransaction(0x2020040, dataBuffer, dataSize);
                break;
            }
            case 2: {
                this.setTransaction(0x2020440, dataBuffer, dataSize);
                break;
            }
            case 3: {
                this.setTransaction(33688640, dataBuffer, dataSize);
                break;
            }
            case 1: {
                this.setTransaction(33689664, dataBuffer, dataSize);
                break;
            }
            case 4: {
                this.setTransaction(33687616, dataBuffer, dataSize);
            }
        }
    }

    public void changeControlMode(ControlMode controlMode) throws CANTimeoutException {
        this.disableControl();
        this.m_controlMode = controlMode;
        UsageReporting.report(9, this.m_deviceNumber, this.m_controlMode.value);
    }

    public ControlMode getControlMode() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        dataSize = this.getTransaction(33691200, dataBuffer);
        if (dataSize == 1) {
            switch (dataBuffer[0]) {
                case 0: {
                    return ControlMode.kPercentVbus;
                }
                case 1: {
                    return ControlMode.kCurrent;
                }
                case 2: {
                    return ControlMode.kSpeed;
                }
                case 3: {
                    return ControlMode.kPosition;
                }
                case 4: {
                    return ControlMode.kVoltage;
                }
            }
        }
        return ControlMode.kPercentVbus;
    }

    public double getBusVoltage() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        dataSize = this.getTransaction(33690688, dataBuffer);
        if (dataSize == 2) {
            return this.unpackFXP8_8(dataBuffer);
        }
        return 0.0;
    }

    public double getOutputVoltage() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = 0;
        dataSize = this.getTransaction(33691264, dataBuffer);
        if (dataSize == 2) {
            return this.unpackFXP8_8(dataBuffer);
        }
        return 0.0;
    }

    public double getOutputCurrent() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33690752, dataBuffer);
        if (dataSize == 2) {
            return this.unpackFXP8_8(dataBuffer);
        }
        return 0.0;
    }

    public double getTemperature() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33690816, dataBuffer);
        if (dataSize == 2) {
            return this.unpackFXP8_8(dataBuffer);
        }
        return 0.0;
    }

    public double getPosition() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33690880, dataBuffer);
        if (dataSize == 4) {
            return this.unpackFXP16_16(dataBuffer);
        }
        return 0.0;
    }

    public double getSpeed() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33690944, dataBuffer);
        if (dataSize == 4) {
            return this.unpackFXP16_16(dataBuffer);
        }
        return 0.0;
    }

    public boolean getForwardLimitOK() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33691008, dataBuffer);
        if (dataSize == 1) {
            return (dataBuffer[0] & 1) != 0;
        }
        return false;
    }

    public boolean getReverseLimitOK() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33691008, dataBuffer);
        if (dataSize == 1) {
            return (dataBuffer[0] & 2) != 0;
        }
        return false;
    }

    public short getFaults() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33691072, dataBuffer);
        if (dataSize == 2) {
            return (short)this.unpackINT16(dataBuffer);
        }
        return 0;
    }

    public boolean getPowerCycled() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(33691136, dataBuffer);
        if (dataSize == 1) {
            boolean powerCycled;
            boolean bl = powerCycled = dataBuffer[0] != 0;
            if (powerCycled) {
                dataBuffer[0] = 1;
                this.setTransaction(33691136, dataBuffer, (byte)1);
            }
            return powerCycled;
        }
        return false;
    }

    public void setVoltageRampRate(double rampRate) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        switch (this.m_controlMode.value) {
            case 0: {
                byte dataSize = this.packPercentage(dataBuffer, rampRate / (this.m_maxOutputVoltage * 1000.0));
                this.setTransaction(0x20200C0, dataBuffer, dataSize);
                break;
            }
            case 4: {
                byte dataSize = this.packFXP8_8(dataBuffer, rampRate / 1000.0);
                this.setTransaction(33687744, dataBuffer, dataSize);
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getFirmwareVersion() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(-2147483136, dataBuffer);
        if (dataSize == 4) {
            return (int)this.unpackINT32(dataBuffer);
        }
        return 0;
    }

    public byte getHardwareVersion() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.getTransaction(520225088, dataBuffer);
        if (dataSize == 2 && dataBuffer[0] == this.m_deviceNumber) {
            return dataBuffer[1];
        }
        return 1;
    }

    public void configNeutralMode(NeutralMode mode) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        dataBuffer[0] = mode.value;
        this.setTransaction(33692864, dataBuffer, (byte)1);
    }

    public void configEncoderCodesPerRev(int codesPerRev) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.packINT16(dataBuffer, (short)codesPerRev);
        this.setTransaction(33692736, dataBuffer, dataSize);
    }

    public void configPotentiometerTurns(int turns) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.packINT16(dataBuffer, (short)turns);
        this.setTransaction(33692800, dataBuffer, dataSize);
    }

    public void configSoftPositionLimits(double forwardLimitPosition, double reverseLimitPosition) throws CANTimeoutException {
        byte dataSize;
        byte[] dataBuffer = new byte[8];
        byte by = dataSize = this.packFXP16_16(dataBuffer, forwardLimitPosition);
        dataSize = (byte)(dataSize + 1);
        dataBuffer[by] = forwardLimitPosition > reverseLimitPosition ? (byte)1 : 0;
        this.setTransaction(33692992, dataBuffer, dataSize);
        byte by2 = dataSize = this.packFXP16_16(dataBuffer, reverseLimitPosition);
        dataSize = (byte)(dataSize + 1);
        dataBuffer[by2] = forwardLimitPosition <= reverseLimitPosition ? (byte)1 : 0;
        this.setTransaction(33693056, dataBuffer, dataSize);
        dataBuffer[0] = 1;
        this.setTransaction(33692928, dataBuffer, (byte)1);
    }

    public void disableSoftPositionLimits() throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        dataBuffer[0] = 0;
        this.setTransaction(33692928, dataBuffer, (byte)1);
    }

    public void configMaxOutputVoltage(double voltage) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        this.m_maxOutputVoltage = voltage;
        byte dataSize = this.packFXP8_8(dataBuffer, voltage);
        this.setTransaction(33693120, dataBuffer, dataSize);
    }

    public void configFaultTime(double faultTime) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        byte dataSize = this.packINT16(dataBuffer, (short)(faultTime * 1000.0));
        this.setTransaction(33693184, dataBuffer, dataSize);
    }

    public static void updateSyncGroup(byte syncGroup) throws CANTimeoutException {
        byte[] dataBuffer = new byte[8];
        dataBuffer[0] = syncGroup;
        CANJaguar.sendMessage(384, dataBuffer, 1);
    }

    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    public String getDescription() {
        return "CANJaguar ID " + this.m_deviceNumber;
    }

    public void stopMotor() {
        try {
            this.disableControl();
        }
        catch (CANTimeoutException cANTimeoutException) {
            // empty catch block
        }
    }

    public String getSmartDashboardType() {
        return "Speed Controller";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void startLiveWindowMode() {
        this.set(0.0);
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                CANJaguar.this.set((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    public void stopLiveWindowMode() {
        this.set(0.0);
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static class LimitMode {
        public final byte value;
        static final byte kSwitchInputsOnly_val = 0;
        static final byte kSoftPositionLimit_val = 1;
        public static final LimitMode kSwitchInputsOnly = new LimitMode(0);
        public static final LimitMode kSoftPostionLimits = new LimitMode(1);

        private LimitMode(byte value) {
            this.value = value;
        }
    }

    public static class NeutralMode {
        public final byte value;
        static final byte kJumper_val = 0;
        static final byte kBrake_val = 1;
        static final byte kCoast_val = 2;
        public static final NeutralMode kJumper = new NeutralMode(0);
        public static final NeutralMode kBrake = new NeutralMode(1);
        public static final NeutralMode kCoast = new NeutralMode(2);

        private NeutralMode(byte value) {
            this.value = value;
        }
    }

    public static class SpeedReference {
        public final byte value;
        static final byte kEncoder_val = 0;
        static final byte kInvEncoder_val = 2;
        static final byte kQuadEncoder_val = 3;
        static final byte kNone_val = -1;
        public static final SpeedReference kEncoder = new SpeedReference(0);
        public static final SpeedReference kInvEncoder = new SpeedReference(2);
        public static final SpeedReference kQuadEncoder = new SpeedReference(3);
        public static final SpeedReference kNone = new SpeedReference(-1);

        private SpeedReference(byte value) {
            this.value = value;
        }
    }

    public static class PositionReference {
        public final byte value;
        static final byte kQuadEncoder_val = 0;
        static final byte kPotentiometer_val = 1;
        static final byte kNone_val = -1;
        public static final PositionReference kQuadEncoder = new PositionReference(0);
        public static final PositionReference kPotentiometer = new PositionReference(1);
        public static final PositionReference kNone = new PositionReference(-1);

        private PositionReference(byte value) {
            this.value = value;
        }
    }

    public static class Limits {
        public final int value;
        static final int kForwardLimit_val = 1;
        static final int kReverseLimit_val = 2;
        public static final Limits kForwardLimit = new Limits(1);
        public static final Limits kReverseLimit = new Limits(2);

        private Limits(int value) {
            this.value = value;
        }
    }

    public static class Faults {
        public final int value;
        static final int kCurrentFault_val = 1;
        static final int kTemperatureFault_val = 2;
        static final int kBusVoltageFault_val = 4;
        static final int kGateDriverFault_val = 8;
        public static final Faults kCurrentFault = new Faults(1);
        public static final Faults kTemperatureFault = new Faults(2);
        public static final Faults kBusVoltageFault = new Faults(4);
        public static final Faults kGateDriverFault = new Faults(8);

        private Faults(int value) {
            this.value = value;
        }
    }

    public static class ControlMode {
        public final int value;
        static final int kPercentVbus_val = 0;
        static final int kCurrent_val = 1;
        static final int kSpeed_val = 2;
        static final int kPosition_val = 3;
        static final int kVoltage_val = 4;
        public static final ControlMode kPercentVbus = new ControlMode(0);
        public static final ControlMode kCurrent = new ControlMode(1);
        public static final ControlMode kSpeed = new ControlMode(2);
        public static final ControlMode kPosition = new ControlMode(3);
        public static final ControlMode kVoltage = new ControlMode(4);

        private ControlMode(int value) {
            this.value = value;
        }
    }
}

