/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Relay;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.IDevice;
import edu.wpi.first.wpilibj.tables.ITable;

public class Compressor
extends SensorBase
implements IDevice,
LiveWindowSendable {
    private DigitalInput m_pressureSwitch;
    private Relay m_relay;
    private boolean m_enabled;
    private Thread m_task;
    private boolean m_run = true;
    private ITable m_table;

    private void initCompressor(int pressureSwitchSlot, int pressureSwitchChannel, int compresssorRelaySlot, int compressorRelayChannel) {
        this.m_enabled = false;
        this.m_pressureSwitch = new DigitalInput(pressureSwitchSlot, pressureSwitchChannel);
        this.m_relay = new Relay(compresssorRelaySlot, compressorRelayChannel, Relay.Direction.kForward);
        UsageReporting.report(10, 0);
        this.m_task = new CompressorThread(this);
        this.m_task.start();
    }

    public Compressor(int pressureSwitchSlot, int pressureSwitchChannel, int compresssorRelaySlot, int compressorRelayChannel) {
        this.initCompressor(pressureSwitchSlot, pressureSwitchChannel, compresssorRelaySlot, compressorRelayChannel);
    }

    public Compressor(int pressureSwitchChannel, int compressorRelayChannel) {
        this.initCompressor(Compressor.getDefaultDigitalModule(), pressureSwitchChannel, Compressor.getDefaultDigitalModule(), compressorRelayChannel);
    }

    public void free() {
        this.m_run = false;
        try {
            this.m_task.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_pressureSwitch.free();
        this.m_relay.free();
        this.m_pressureSwitch = null;
        this.m_relay = null;
    }

    public void setRelayValue(Relay.Value relayValue) {
        this.m_relay.set(relayValue);
    }

    public boolean getPressureSwitchValue() {
        return this.m_pressureSwitch.get();
    }

    public void start() {
        this.m_enabled = true;
    }

    public void stop() {
        this.m_enabled = false;
    }

    public boolean enabled() {
        return this.m_enabled;
    }

    public String getSmartDashboardType() {
        return "Compressor";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Enabled", this.m_enabled);
            this.m_table.putBoolean("Pressure Switch", this.getPressureSwitchValue());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }

    private class CompressorThread
    extends Thread {
        Compressor m_compressor;

        CompressorThread(Compressor comp) {
            this.m_compressor = comp;
        }

        public void run() {
            while (Compressor.this.m_run) {
                if (this.m_compressor.enabled()) {
                    this.m_compressor.setRelayValue(!this.m_compressor.getPressureSwitchValue() ? Relay.Value.kOn : Relay.Value.kOff);
                } else {
                    this.m_compressor.setRelayValue(Relay.Value.kOff);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

