/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogTrigger;
import edu.wpi.first.wpilibj.AnalogTriggerOutput;
import edu.wpi.first.wpilibj.CounterBase;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.fpga.tCounter;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.BoundaryException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Counter
extends SensorBase
implements CounterBase,
LiveWindowSendable,
PIDSource {
    private DigitalSource m_upSource;
    private DigitalSource m_downSource;
    private boolean m_allocatedUpSource;
    private boolean m_allocatedDownSource;
    private tCounter m_counter;
    private int m_index;
    private static Resource counters = new Resource(8);
    private PIDSource.PIDSourceParameter m_pidSource;
    private double m_distancePerPulse;
    private ITable m_table;

    private void initCounter(Mode mode) {
        this.m_allocatedUpSource = false;
        this.m_allocatedDownSource = false;
        try {
            this.m_index = counters.allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No counters left to be allocated");
        }
        this.m_counter = new tCounter(this.m_index);
        this.m_counter.writeConfig_Mode(mode.value);
        this.m_upSource = null;
        this.m_downSource = null;
        this.m_counter.writeTimerConfig_AverageSize(1);
        UsageReporting.report(11, this.m_index, mode.value);
    }

    public Counter() {
        this.initCounter(Mode.kTwoPulse);
    }

    public Counter(DigitalSource source) {
        if (source == null) {
            throw new NullPointerException("Source given was null");
        }
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(source);
    }

    public Counter(int channel) {
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(channel);
    }

    public Counter(int slot, int channel) {
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(slot, channel);
    }

    public Counter(CounterBase.EncodingType encodingType, DigitalSource upSource, DigitalSource downSource, boolean inverted) {
        this.initCounter(Mode.kExternalDirection);
        if (encodingType != CounterBase.EncodingType.k1X && encodingType != CounterBase.EncodingType.k2X) {
            throw new RuntimeException("Counters only support 1X and 2X quadreature decoding!");
        }
        if (upSource == null) {
            throw new NullPointerException("Up Source given was null");
        }
        this.setUpSource(upSource);
        if (downSource == null) {
            throw new NullPointerException("Down Source given was null");
        }
        this.setDownSource(downSource);
        if (encodingType == null) {
            throw new NullPointerException("Encoding type given was null");
        }
        if (encodingType == CounterBase.EncodingType.k1X) {
            this.setUpSourceEdge(true, false);
        } else {
            this.setUpSourceEdge(true, true);
        }
        this.setDownSourceEdge(inverted, true);
    }

    public Counter(AnalogTrigger trigger) {
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(trigger.createOutput(AnalogTriggerOutput.Type.kTypeState));
    }

    public void free() {
        this.setUpdateWhenEmpty(true);
        this.clearUpSource();
        this.clearDownSource();
        this.m_counter.Release();
        this.m_upSource = null;
        this.m_downSource = null;
        this.m_counter = null;
        counters.free(this.m_index);
    }

    public void setUpSource(int slot, int channel) {
        this.setUpSource(new DigitalInput(slot, channel));
        this.m_allocatedUpSource = true;
    }

    public void setUpSource(int channel) {
        this.setUpSource(new DigitalInput(channel));
        this.m_allocatedUpSource = true;
    }

    public void setUpSource(DigitalSource source) {
        if (this.m_upSource != null && this.m_allocatedUpSource) {
            this.m_upSource.free();
            this.m_allocatedUpSource = false;
        }
        this.m_upSource = source;
        this.m_counter.writeConfig_UpSource_Module(source.getModuleForRouting());
        this.m_counter.writeConfig_UpSource_Channel(source.getChannelForRouting());
        this.m_counter.writeConfig_UpSource_AnalogTrigger(source.getAnalogTriggerForRouting());
        if (this.m_counter.readConfig_Mode() == Mode.kTwoPulse.value || this.m_counter.readConfig_Mode() == Mode.kExternalDirection.value) {
            this.setUpSourceEdge(true, false);
        }
        this.m_counter.strobeReset();
    }

    public void setUpSource(AnalogTrigger analogTrigger, AnalogTriggerOutput.Type triggerType) {
        this.setUpSource(analogTrigger.createOutput(triggerType));
        this.m_allocatedUpSource = true;
    }

    public void setUpSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_upSource == null) {
            throw new RuntimeException("Up Source must be set before setting the edge!");
        }
        this.m_counter.writeConfig_UpRisingEdge(risingEdge);
        this.m_counter.writeConfig_UpFallingEdge(fallingEdge);
    }

    public void clearUpSource() {
        if (this.m_upSource != null && this.m_allocatedUpSource) {
            this.m_upSource.free();
            this.m_allocatedUpSource = false;
        }
        this.m_upSource = null;
        boolean state = this.m_counter.readConfig_Enable();
        this.m_counter.writeConfig_Enable(false);
        this.m_counter.writeConfig_UpFallingEdge(false);
        this.m_counter.writeConfig_UpRisingEdge(false);
        this.m_counter.writeConfig_UpSource_Channel(0);
        this.m_counter.writeConfig_UpSource_AnalogTrigger(false);
        this.m_counter.writeConfig_Enable(state);
    }

    public void setDownSource(int channel) {
        this.setDownSource(new DigitalInput(channel));
        this.m_allocatedDownSource = true;
    }

    public void setDownSource(int slot, int channel) {
        this.setDownSource(new DigitalInput(slot, channel));
        this.m_allocatedDownSource = true;
    }

    public void setDownSource(DigitalSource source) {
        byte mode;
        if (this.m_downSource != null && this.m_allocatedDownSource) {
            this.m_downSource.free();
            this.m_allocatedDownSource = false;
        }
        if ((mode = this.m_counter.readConfig_Mode()) != 0 && mode != 3) {
            throw new RuntimeException("Down Source only supported in TwoPulse and ExternalDirection modes!");
        }
        this.m_downSource = source;
        this.m_counter.writeConfig_DownSource_Module(source.getModuleForRouting());
        this.m_counter.writeConfig_DownSource_Channel(source.getChannelForRouting());
        this.m_counter.writeConfig_DownSource_AnalogTrigger(source.getAnalogTriggerForRouting());
        this.setDownSourceEdge(true, false);
        this.m_counter.strobeReset();
    }

    public void setDownSource(AnalogTrigger analogTrigger, AnalogTriggerOutput.Type triggerType) {
        this.setDownSource(analogTrigger.createOutput(triggerType));
        this.m_allocatedDownSource = true;
    }

    public void setDownSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_downSource == null) {
            throw new RuntimeException(" Down Source must be set before setting the edge!");
        }
        this.m_counter.writeConfig_DownRisingEdge(risingEdge);
        this.m_counter.writeConfig_DownFallingEdge(fallingEdge);
    }

    public void clearDownSource() {
        if (this.m_downSource != null && this.m_allocatedDownSource) {
            this.m_downSource.free();
            this.m_allocatedDownSource = false;
        }
        this.m_downSource = null;
        boolean state = this.m_counter.readConfig_Enable();
        this.m_counter.writeConfig_Enable(false);
        this.m_counter.writeConfig_DownFallingEdge(false);
        this.m_counter.writeConfig_DownRisingEdge(false);
        this.m_counter.writeConfig_DownSource_Channel(0);
        this.m_counter.writeConfig_DownSource_AnalogTrigger(false);
        this.m_counter.writeConfig_Enable(state);
    }

    public void setUpDownCounterMode() {
        this.m_counter.writeConfig_Mode(Mode.kTwoPulse.value);
    }

    public void setExternalDirectionMode() {
        this.m_counter.writeConfig_Mode(Mode.kExternalDirection.value);
    }

    public void setSemiPeriodMode(boolean highSemiPeriod) {
        this.m_counter.writeConfig_Mode(Mode.kSemiperiod.value);
        this.m_counter.writeConfig_UpRisingEdge(highSemiPeriod);
        this.setUpdateWhenEmpty(false);
    }

    public void setPulseLengthMode(double threshold) {
        this.m_counter.writeConfig_Mode(Mode.kPulseLength.value);
        this.m_counter.writeConfig_PulseLengthThreshold((short)(threshold * 1000000.0 * 40.0));
    }

    public void start() {
        this.m_counter.writeConfig_Enable(true);
    }

    public int get() {
        return this.m_counter.readOutput_Value();
    }

    public double getDistance() {
        return (double)this.m_counter.readOutput_Value() * this.m_distancePerPulse;
    }

    public void reset() {
        this.m_counter.strobeReset();
    }

    public void stop() {
        this.m_counter.writeConfig_Enable(false);
    }

    public void setMaxPeriod(double maxPeriod) {
        this.m_counter.writeTimerConfig_StallPeriod((int)(maxPeriod * 1000000.0));
    }

    public void setUpdateWhenEmpty(boolean enabled) {
        this.m_counter.writeTimerConfig_UpdateWhenEmpty(enabled);
    }

    public boolean getStopped() {
        return this.m_counter.readTimerOutput_Stalled();
    }

    public boolean getDirection() {
        boolean value = this.m_counter.readOutput_Direction();
        return value;
    }

    public void setReverseDirection(boolean reverseDirection) {
        if (this.m_counter.readConfig_Mode() == Mode.kExternalDirection.value) {
            if (reverseDirection) {
                this.setDownSourceEdge(true, true);
            } else {
                this.setDownSourceEdge(false, true);
            }
        }
    }

    public double getPeriod() {
        if (this.m_counter.readTimerOutput_Stalled()) {
            return Double.POSITIVE_INFINITY;
        }
        double period = (double)this.m_counter.readTimerOutput_Period() / (double)this.m_counter.readTimerOutput_Count();
        return period / 1000000.0;
    }

    public double getRate() {
        return this.m_distancePerPulse / this.getPeriod();
    }

    public void setSamplesToAverage(int samplesToAverage) {
        BoundaryException.assertWithinBounds(samplesToAverage, 1.0, 127.0);
        this.m_counter.writeTimerConfig_AverageSize(samplesToAverage);
    }

    public int getSamplesToAverage() {
        return this.m_counter.readTimerConfig_AverageSize();
    }

    public void setDistancePerPulse(double distancePerPulse) {
        this.m_distancePerPulse = distancePerPulse;
    }

    public void setPIDSourceParameter(PIDSource.PIDSourceParameter pidSource) {
        BoundaryException.assertWithinBounds(pidSource.value, 0.0, 1.0);
        this.m_pidSource = pidSource;
    }

    public double pidGet() {
        switch (this.m_pidSource.value) {
            case 0: {
                return this.getDistance();
            }
            case 1: {
                return this.getRate();
            }
        }
        return 0.0;
    }

    public String getSmartDashboardType() {
        return "Counter";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", (double)this.m_counter.readOutput_Value());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }

    public static class Mode {
        public final int value;
        static final int kTwoPulse_val = 0;
        static final int kSemiperiod_val = 1;
        static final int kPulseLength_val = 2;
        static final int kExternalDirection_val = 3;
        public static final Mode kTwoPulse = new Mode(0);
        public static final Mode kSemiperiod = new Mode(1);
        public static final Mode kPulseLength = new Mode(2);
        public static final Mode kExternalDirection = new Mode(3);

        private Mode(int value) {
            this.value = value;
        }
    }
}

