/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.IDashboard;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.parsing.IInputOutput;
import java.util.Stack;

public class Dashboard
implements IDashboard,
IInputOutput {
    private static final String kArray = "Array";
    private static final String kCluster = "Cluster";
    private static final Integer kByte = new Integer(0);
    private static final Integer kShort = new Integer(1);
    private static final Integer kInt = new Integer(2);
    private static final Integer kFloat = new Integer(3);
    private static final Integer kDouble = new Integer(4);
    private static final Integer kString = new Integer(5);
    private static final Integer kOther = new Integer(6);
    private static final Integer kBoolean = new Integer(7);
    private static final int kMaxDashboardDataSize = 971;
    private static boolean m_reported = false;
    protected MemAccess m_userStatus;
    protected int m_userStatusSize = 0;
    private MemAccess m_localBuffer;
    private int m_packPtr = 0;
    private Stack m_expectedArrayElementType = new Stack();
    private Stack m_arrayElementCount = new Stack();
    private Stack m_arraySizePtr = new Stack();
    private Stack m_complexTypeStack = new Stack();
    private final Object m_statusDataSemaphore;

    protected Dashboard(Object statusDataSemaphore) {
        this.m_userStatus = new MemAccess(971);
        this.m_localBuffer = new MemAccess(971);
        this.m_statusDataSemaphore = statusDataSemaphore;
    }

    public boolean addByte(byte value) {
        if (!this.validateAdd(1)) {
            return false;
        }
        this.m_localBuffer.setByte(this.m_packPtr, value);
        ++this.m_packPtr;
        return this.addedElement(kByte);
    }

    public boolean addShort(short value) {
        if (!this.validateAdd(2)) {
            return false;
        }
        this.m_localBuffer.setShort(this.m_packPtr, value);
        this.m_packPtr += 2;
        return this.addedElement(kShort);
    }

    public boolean addInt(int value) {
        if (!this.validateAdd(4)) {
            return false;
        }
        this.m_localBuffer.setInt(this.m_packPtr, value);
        this.m_packPtr += 4;
        return this.addedElement(kInt);
    }

    public boolean addFloat(float value) {
        if (!this.validateAdd(4)) {
            return false;
        }
        this.m_localBuffer.setFloat(this.m_packPtr, value);
        this.m_packPtr += 4;
        return this.addedElement(kFloat);
    }

    public boolean addDouble(double value) {
        if (!this.validateAdd(8)) {
            return false;
        }
        this.m_localBuffer.setDouble(this.m_packPtr, value);
        this.m_packPtr += 8;
        return this.addedElement(kDouble);
    }

    public boolean addBoolean(boolean value) {
        if (!this.validateAdd(1)) {
            return false;
        }
        this.m_localBuffer.setByte(this.m_packPtr, (byte)(value ? 1 : 0));
        ++this.m_packPtr;
        return this.addedElement(kBoolean);
    }

    public boolean addString(String value) {
        if (!this.validateAdd(value.length() + 4)) {
            return false;
        }
        this.m_localBuffer.setInt(this.m_packPtr, value.length());
        this.m_packPtr += 4;
        this.m_localBuffer.setString(this.m_packPtr, value);
        this.m_packPtr += value.length();
        return this.addedElement(kString);
    }

    public boolean addString(String value, int length) {
        return this.addString(value.substring(0, length));
    }

    public boolean addArray() {
        if (!this.validateAdd(4)) {
            return false;
        }
        this.m_complexTypeStack.push(kArray);
        this.m_arrayElementCount.push(new Integer(0));
        this.m_arraySizePtr.push(new Integer(this.m_packPtr));
        this.m_packPtr += 4;
        return true;
    }

    public boolean finalizeArray() {
        if (this.m_complexTypeStack.peek() != kArray) {
            System.err.println("Attempted to finalize an array in the middle of a cluster or without starting the array");
            return false;
        }
        this.m_complexTypeStack.pop();
        this.m_localBuffer.setInt((Integer)this.m_arraySizePtr.pop(), (Integer)this.m_arrayElementCount.peek());
        if ((Integer)this.m_arrayElementCount.peek() != 0) {
            this.m_expectedArrayElementType.pop();
        }
        this.m_arrayElementCount.pop();
        return this.addedElement(kOther);
    }

    public boolean addCluster() {
        this.m_complexTypeStack.push(kCluster);
        return true;
    }

    public boolean finalizeCluster() {
        if (this.m_complexTypeStack.peek() != kCluster) {
            System.err.println("Attempted to close a cluster on an open array or without starting the cluster");
            return false;
        }
        this.m_complexTypeStack.pop();
        return this.addedElement(kOther);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int commit() {
        if (!this.m_complexTypeStack.empty()) {
            System.err.println("didn't finish complex type");
            this.m_packPtr = 0;
            System.err.println("didn't finish complex type");
            return 0;
        }
        if (!m_reported) {
            UsageReporting.report(12, 0);
            m_reported = true;
        }
        Object object = this.m_statusDataSemaphore;
        synchronized (object) {
            DriverStation.getInstance().incrementUpdateNumber();
            this.m_userStatusSize = this.m_packPtr;
            this.m_userStatus.setBytes(0, this.m_localBuffer.m_bytes, 0, this.m_userStatusSize);
            this.m_packPtr = 0;
        }
        return this.m_userStatusSize;
    }

    private boolean validateAdd(int size) {
        if (this.m_packPtr + size > 971) {
            this.m_packPtr = 0;
            System.err.println("Dashboard data is too long to send");
            return false;
        }
        return true;
    }

    private boolean addedElement(Integer type) {
        if (this.isArrayRoot()) {
            if ((Integer)this.m_arrayElementCount.peek() == 0) {
                this.m_expectedArrayElementType.push(type);
            } else if (type != this.m_expectedArrayElementType.peek()) {
                System.err.println("Attempted to add multiple datatypes to the same array");
                return false;
            }
            this.m_arrayElementCount.push(new Integer((Integer)this.m_arrayElementCount.pop() + 1));
        }
        return true;
    }

    private boolean isArrayRoot() {
        return !this.m_complexTypeStack.empty() && this.m_complexTypeStack.peek() == kArray;
    }

    public byte[] getBytes() {
        return this.m_userStatus.m_bytes;
    }

    public int getBytesLength() {
        return this.m_userStatusSize;
    }

    public void flush() {
    }

    protected class MemAccess {
        byte[] m_bytes;

        protected MemAccess(byte[] bytes) {
            this.m_bytes = bytes;
        }

        protected MemAccess(int length) {
            this.m_bytes = new byte[length];
        }

        public void setByte(int index, byte value) {
            this.m_bytes[index] = value;
        }

        public void setShort(int index, short value) {
            this.setByte(index++, (byte)(value >>> 8));
            this.setByte(index++, (byte)value);
        }

        public void setInt(int index, int value) {
            this.setByte(index++, (byte)(value >>> 24));
            this.setByte(index++, (byte)(value >>> 16));
            this.setByte(index++, (byte)(value >>> 8));
            this.setByte(index++, (byte)value);
        }

        public void setFloat(int index, float value) {
            this.setInt(index, Float.floatToIntBits(value));
        }

        public void setDouble(int index, double value) {
            this.setInt(index, (int)(Double.doubleToLongBits(value) >>> 32));
            this.setInt(index + 4, (int)Double.doubleToLongBits(value));
        }

        public void setString(int index, String value) {
            this.setBytes(index, value.getBytes(), 0, value.length());
        }

        public void setBytes(int index, byte[] value, int offset, int number) {
            for (int i = 0; i < number; ++i) {
                this.m_bytes[i + index] = value[i + offset];
            }
        }
    }
}

