/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.fpga.tDIO;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.IInputOutput;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class DigitalOutput
extends DigitalSource
implements IInputOutput,
LiveWindowSendable {
    private int m_channel;
    private int m_pwmGenerator;
    private DigitalModule m_module;
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initDigitalOutput(int moduleNumber, int channel) {
        this.m_channel = channel;
        this.m_pwmGenerator = -1;
        this.m_module = DigitalModule.getInstance(moduleNumber);
        this.m_module.allocateDIO(this.m_channel, false);
        UsageReporting.report(14, channel, moduleNumber - 1);
    }

    public DigitalOutput(int moduleNumber, int channel) {
        this.initDigitalOutput(moduleNumber, channel);
    }

    public DigitalOutput(int channel) {
        this.initDigitalOutput(DigitalOutput.getDefaultDigitalModule(), channel);
    }

    public void free() {
        this.disablePWM();
        this.m_module.freeDIO(this.m_channel);
    }

    public void set(boolean value) {
        this.m_module.setDIO(this.m_channel, value);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void pulse(double length) {
        this.m_module.pulse(this.m_channel, (char)(1.0E9 * length / (double)(tDIO.readLoopTiming() * 25)));
    }

    public boolean isPulsing() {
        return this.m_module.isPulsing(this.m_channel);
    }

    public void setPWMRate(double rate) {
        this.m_module.setDO_PWMRate(rate);
    }

    public void enablePWM(double initialDutyCycle) {
        if (this.m_pwmGenerator != -1) {
            return;
        }
        this.m_pwmGenerator = this.m_module.allocateDO_PWM();
        this.m_module.setDO_PWMDutyCycle(this.m_pwmGenerator, initialDutyCycle);
        this.m_module.setDO_PWMOutputChannel(this.m_pwmGenerator, this.m_channel);
    }

    public void disablePWM() {
        this.m_module.setDO_PWMOutputChannel(this.m_pwmGenerator, 14);
        this.m_module.freeDO_PWM(this.m_pwmGenerator);
        this.m_pwmGenerator = -1;
    }

    public void updateDutyCycle(double dutyCycle) {
        this.m_module.setDO_PWMDutyCycle(this.m_pwmGenerator, dutyCycle);
    }

    public int getChannelForRouting() {
        return DigitalModule.remapDigitalChannel(this.getChannel() - 1);
    }

    public int getModuleForRouting() {
        return this.m_module.getModuleNumber() - 1;
    }

    public boolean getAnalogTriggerForRouting() {
        return false;
    }

    public String getSmartDashboardType() {
        return "Digital Output";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
    }

    public void startLiveWindowMode() {
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                DigitalOutput.this.set((Boolean)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_table_listener);
    }
}

