/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class DoubleSolenoid
extends SolenoidBase
implements LiveWindowSendable {
    private int m_forwardChannel;
    private int m_reverseChannel;
    private byte m_forwardMask;
    private byte m_reverseMask;
    private ITable m_table;
    private ITableListener m_table_listener;

    private synchronized void initSolenoid() {
        DoubleSolenoid.checkSolenoidModule(this.m_moduleNumber);
        DoubleSolenoid.checkSolenoidChannel(this.m_forwardChannel);
        DoubleSolenoid.checkSolenoidChannel(this.m_reverseChannel);
        try {
            m_allocated.allocate((this.m_moduleNumber - 1) * 8 + this.m_forwardChannel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_forwardChannel + " on module " + this.m_moduleNumber + " is already allocated");
        }
        try {
            m_allocated.allocate((this.m_moduleNumber - 1) * 8 + this.m_reverseChannel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_reverseChannel + " on module " + this.m_moduleNumber + " is already allocated");
        }
        this.m_forwardMask = (byte)(1 << this.m_forwardChannel - 1);
        this.m_reverseMask = (byte)(1 << this.m_reverseChannel - 1);
        UsageReporting.report(34, this.m_forwardChannel, this.m_moduleNumber - 1);
        UsageReporting.report(34, this.m_reverseChannel, this.m_moduleNumber - 1);
        LiveWindow.addActuator("DoubleSolenoid", this.m_moduleNumber, this.m_forwardChannel, this);
    }

    public DoubleSolenoid(int forwardChannel, int reverseChannel) {
        super(DoubleSolenoid.getDefaultSolenoidModule());
        this.m_forwardChannel = forwardChannel;
        this.m_reverseChannel = reverseChannel;
        this.initSolenoid();
    }

    public DoubleSolenoid(int moduleNumber, int forwardChannel, int reverseChannel) {
        super(moduleNumber);
        this.m_forwardChannel = forwardChannel;
        this.m_reverseChannel = reverseChannel;
        this.initSolenoid();
    }

    public synchronized void free() {
        m_allocated.free((this.m_moduleNumber - 1) * 8 + this.m_forwardChannel - 1);
        m_allocated.free((this.m_moduleNumber - 1) * 8 + this.m_reverseChannel - 1);
    }

    public void set(Value value) {
        byte rawValue = 0;
        switch (value.value) {
            case 0: {
                rawValue = 0;
                break;
            }
            case 1: {
                rawValue = this.m_forwardMask;
                break;
            }
            case 2: {
                rawValue = this.m_reverseMask;
            }
        }
        this.set(rawValue, this.m_forwardMask | this.m_reverseMask);
    }

    public Value get() {
        byte value = this.getAll();
        if ((value & this.m_forwardMask) != 0) {
            return Value.kForward;
        }
        if ((value & this.m_reverseMask) != 0) {
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public String getSmartDashboardType() {
        return "Double Solenoid";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putString("Value", this.get() == Value.kForward ? "Forward" : (this.get() == Value.kReverse ? "Reverse" : "Off"));
        }
    }

    public void startLiveWindowMode() {
        this.set(Value.kOff);
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                if (value.toString().equals("Reverse")) {
                    DoubleSolenoid.this.set(Value.kReverse);
                } else if (value.toString().equals("Forward")) {
                    DoubleSolenoid.this.set(Value.kForward);
                } else {
                    DoubleSolenoid.this.set(Value.kOff);
                }
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    public void stopLiveWindowMode() {
        this.set(Value.kOff);
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static class Value {
        public final int value;
        public static final int kOff_val = 0;
        public static final int kForward_val = 1;
        public static final int kReverse_val = 2;
        public static final Value kOff = new Value(0);
        public static final Value kForward = new Value(1);
        public static final Value kReverse = new Value(2);

        private Value(int value) {
            this.value = value;
        }
    }
}

