/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.parsing.IInputOutput;

public class DriverStationLCD
extends SensorBase
implements IInputOutput {
    private static DriverStationLCD m_instance;
    public static final int kSyncTimeout_ms = 20;
    public static final int kFullDisplayTextCommand = 40959;
    public static final int kLineLength = 21;
    public static final int kNumLines = 6;
    byte[] m_textBuffer = new byte[128];

    public static synchronized DriverStationLCD getInstance() {
        if (m_instance == null) {
            m_instance = new DriverStationLCD();
        }
        return m_instance;
    }

    private DriverStationLCD() {
        for (int i = 0; i < 128; ++i) {
            this.m_textBuffer[i] = 32;
        }
        this.m_textBuffer[0] = -97;
        this.m_textBuffer[1] = -1;
        UsageReporting.report(17, 0);
    }

    public synchronized void updateLCD() {
        FRCControl.setUserDsLcdData(this.m_textBuffer, 128, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Line line, int startingColumn, String text) {
        int start = startingColumn - 1;
        int maxLength = 21 - start;
        if (startingColumn < 1 || startingColumn > 21) {
            throw new IndexOutOfBoundsException("Column must be between 1 and 21, inclusive");
        }
        int length = text.length();
        int finalLength = length < maxLength ? length : maxLength;
        DriverStationLCD driverStationLCD = this;
        synchronized (driverStationLCD) {
            for (int i = 0; i < finalLength; ++i) {
                this.m_textBuffer[i + start + line.value * 21 + 2] = (byte)text.charAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Line line, int startingColumn, StringBuffer text) {
        int start = startingColumn - 1;
        int maxLength = 21 - start;
        if (startingColumn < 1 || startingColumn > 21) {
            throw new IndexOutOfBoundsException("Column must be between 1 and 21, inclusive");
        }
        int length = text.length();
        int finalLength = length < maxLength ? length : maxLength;
        DriverStationLCD driverStationLCD = this;
        synchronized (driverStationLCD) {
            for (int i = 0; i < finalLength; ++i) {
                this.m_textBuffer[i + start + line.value * 21 + 2] = (byte)text.charAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DriverStationLCD driverStationLCD = this;
        synchronized (driverStationLCD) {
            for (int i = 0; i < 126; ++i) {
                this.m_textBuffer[i + 2] = 32;
            }
        }
        this.updateLCD();
    }

    public static class Line {
        public final int value;
        static final int kMain6_val = 0;
        static final int kUser1_val = 0;
        static final int kUser2_val = 1;
        static final int kUser3_val = 2;
        static final int kUser4_val = 3;
        static final int kUser5_val = 4;
        static final int kUser6_val = 5;
        public static final Line kMain6 = new Line(0);
        public static final Line kUser1 = new Line(0);
        public static final Line kUser2 = new Line(1);
        public static final Line kUser3 = new Line(2);
        public static final Line kUser4 = new Line(3);
        public static final Line kUser5 = new Line(4);
        public static final Line kUser6 = new Line(5);

        private Line(int value) {
            this.value = value;
        }
    }
}

