/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.parsing.ISensor;

public class GearTooth
extends Counter
implements ISensor {
    private static final double kGearToothThreshold = 5.5E-5;

    public void enableDirectionSensing(boolean directionSensitive) {
        if (directionSensitive) {
            this.setPulseLengthMode(5.5E-5);
        }
    }

    public GearTooth(int channel, boolean directionSensitive) {
        super(channel);
        this.enableDirectionSensing(directionSensitive);
        if (directionSensitive) {
            UsageReporting.report(19, channel, DigitalModule.getDefaultDigitalModule() - 1, "D");
        } else {
            UsageReporting.report(19, channel, DigitalModule.getDefaultDigitalModule() - 1);
        }
    }

    public GearTooth(int channel) {
        this(channel, false);
    }

    public GearTooth(int slot, int channel, boolean directionSensitive) {
        super(slot, channel);
        this.enableDirectionSensing(directionSensitive);
        if (directionSensitive) {
            UsageReporting.report(19, channel, DigitalModule.getDefaultDigitalModule() - 1, "D");
        } else {
            UsageReporting.report(19, channel, DigitalModule.getDefaultDigitalModule() - 1);
        }
        LiveWindow.addSensor("GearTooth", slot, channel, this);
    }

    public GearTooth(int slot, int channel) {
        this(slot, channel, false);
    }

    public GearTooth(DigitalSource source, boolean directionSensitive) {
        super(source);
        this.enableDirectionSensing(directionSensitive);
    }

    public GearTooth(DigitalSource source) {
        this(source, false);
    }

    public String getSmartDashboardType() {
        return "Gear Tooth";
    }
}

