/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class Gyro
extends SensorBase
implements PIDSource,
ISensor,
LiveWindowSendable {
    static final int kOversampleBits = 10;
    static final int kAverageBits = 0;
    static final double kSamplesPerSecond = 50.0;
    static final double kCalibrationSampleTime = 5.0;
    static final double kDefaultVoltsPerDegreePerSecond = 0.007;
    AnalogChannel m_analog;
    double m_voltsPerDegreePerSecond;
    double m_offset;
    int m_center;
    boolean m_channelAllocated;
    AccumulatorResult result;
    private PIDSource.PIDSourceParameter m_pidSource;
    private ITable m_table;

    private void initGyro() {
        this.result = new AccumulatorResult();
        if (this.m_analog == null) {
            System.out.println("Null m_analog");
        }
        this.m_voltsPerDegreePerSecond = 0.007;
        this.m_analog.setAverageBits(0);
        this.m_analog.setOversampleBits(10);
        double sampleRate = 51200.0;
        this.m_analog.getModule().setSampleRate(sampleRate);
        Timer.delay(1.0);
        this.m_analog.initAccumulator();
        Timer.delay(5.0);
        this.m_analog.getAccumulatorOutput(this.result);
        this.m_center = (int)((double)this.result.value / (double)this.result.count + 0.5);
        this.m_offset = (double)this.result.value / (double)this.result.count - (double)this.m_center;
        this.m_analog.setAccumulatorCenter(this.m_center);
        this.m_analog.setAccumulatorDeadband(0);
        this.m_analog.resetAccumulator();
        this.setPIDSourceParameter(PIDSource.PIDSourceParameter.kAngle);
        UsageReporting.report(20, this.m_analog.getChannel(), this.m_analog.getModuleNumber() - 1);
        LiveWindow.addSensor("Gyro", this.m_analog.getModuleNumber(), this.m_analog.getChannel(), this);
    }

    public Gyro(int slot, int channel) {
        this.m_analog = new AnalogChannel(slot, channel);
        this.m_channelAllocated = true;
        this.initGyro();
    }

    public Gyro(int channel) {
        this.m_analog = new AnalogChannel(channel);
        this.m_channelAllocated = true;
        this.initGyro();
    }

    public Gyro(AnalogChannel channel) {
        this.m_analog = channel;
        if (this.m_analog == null) {
            System.err.println("Analog channel supplied to Gyro constructor is null");
        } else {
            this.m_channelAllocated = false;
            this.initGyro();
        }
    }

    public void reset() {
        if (this.m_analog != null) {
            this.m_analog.resetAccumulator();
        }
    }

    public void free() {
        if (this.m_analog != null && this.m_channelAllocated) {
            this.m_analog.free();
        }
        this.m_analog = null;
    }

    public double getAngle() {
        if (this.m_analog == null) {
            return 0.0;
        }
        this.m_analog.getAccumulatorOutput(this.result);
        long value = this.result.value - (long)((double)this.result.count * this.m_offset);
        double scaledValue = (double)value * 1.0E-9 * (double)this.m_analog.getLSBWeight() * (double)(1 << this.m_analog.getAverageBits()) / (this.m_analog.getModule().getSampleRate() * this.m_voltsPerDegreePerSecond);
        return scaledValue;
    }

    public double getRate() {
        if (this.m_analog == null) {
            return 0.0;
        }
        return ((double)this.m_analog.getAverageValue() - ((double)this.m_center + this.m_offset)) * 1.0E-9 * (double)this.m_analog.getLSBWeight() / ((double)(1 << this.m_analog.getOversampleBits()) * this.m_voltsPerDegreePerSecond);
    }

    public void setSensitivity(double voltsPerDegreePerSecond) {
        this.m_voltsPerDegreePerSecond = voltsPerDegreePerSecond;
    }

    public void setPIDSourceParameter(PIDSource.PIDSourceParameter pidSource) {
        BoundaryException.assertWithinBounds(pidSource.value, 1.0, 2.0);
        this.m_pidSource = pidSource;
    }

    public double pidGet() {
        switch (this.m_pidSource.value) {
            case 1: {
                return this.getRate();
            }
            case 2: {
                return this.getAngle();
            }
        }
        return 0.0;
    }

    public String getSmartDashboardType() {
        return "Gyro";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAngle());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }
}

