/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.tables.ITable;

public class HiTechnicColorSensor
extends SensorBase
implements ISensor,
LiveWindowSendable {
    private static final byte kAddress = 2;
    private static final byte kManufacturerBaseRegister = 8;
    private static final byte kManufacturerSize = 8;
    private static final byte kSensorTypeBaseRegister = 16;
    private static final byte kSensorTypeSize = 8;
    private static final byte kModeRegister = 65;
    private static final byte kColorRegister = 66;
    private static final byte kRedRegister = 67;
    private static final byte kGreenRegister = 68;
    private static final byte kBlueRegister = 69;
    private static final byte kRawRedRegister = 67;
    private static final byte kRawGreenRegister = 69;
    private static final byte kRawBlueRegister = 71;
    private I2C m_i2c;
    private int m_mode;
    private ITable m_table;
    private NumberArray rgbArray;

    public HiTechnicColorSensor(int slot) {
        this.m_mode = tColorSensorMode.kActive.value;
        this.rgbArray = new NumberArray();
        DigitalModule module = DigitalModule.getInstance(slot);
        this.m_i2c = module.getI2C(2);
        byte[] kExpectedManufacturer = "HiTechnc".getBytes();
        byte[] kExpectedSensorType = "ColorPD ".getBytes();
        if (!this.m_i2c.verifySensor(8, 8, kExpectedManufacturer)) {
            throw new ColorSensorException("Invalid Color Sensor Manufacturer");
        }
        if (!this.m_i2c.verifySensor(16, 8, kExpectedSensorType)) {
            throw new ColorSensorException("Invalid Sensor type");
        }
        LiveWindow.addSensor("HiTechnicColorSensor", slot, 0, this);
        UsageReporting.report(45, module.getModuleNumber() - 1);
    }

    public void free() {
        if (this.m_i2c != null) {
            this.m_i2c.free();
        }
        this.m_i2c = null;
    }

    public byte getColor() {
        byte[] color = new byte[1];
        if (this.m_mode != tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kActive);
        }
        this.m_i2c.read(66, (byte)color.length, color);
        return color[0];
    }

    public RGB getRGB() {
        byte[] colors = new byte[3];
        RGB result = new RGB();
        if (this.m_mode != tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kActive);
        }
        this.m_i2c.read(67, (byte)colors.length, colors);
        result.red = colors[0] & 0xFFFF;
        result.green = colors[1] & 0xFFFF;
        result.blue = colors[2] & 0xFFFF;
        return result;
    }

    public int getRed() {
        byte[] red = new byte[1];
        if (this.m_mode != tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kActive);
        }
        this.m_i2c.read(67, (byte)red.length, red);
        return red[0] & 0xFF;
    }

    public int getGreen() {
        byte[] green = new byte[1];
        if (this.m_mode != tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kActive);
        }
        this.m_i2c.read(68, (byte)green.length, green);
        return green[0] & 0xFF;
    }

    public int getBlue() {
        byte[] blue = new byte[1];
        if (this.m_mode != tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kActive);
        }
        this.m_i2c.read(69, (byte)blue.length, blue);
        return blue[0] & 0xFF;
    }

    public double getRawRed() {
        byte[] rawRed = new byte[2];
        if (this.m_mode == tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kRaw);
        }
        this.m_i2c.read(67, (byte)rawRed.length, rawRed);
        return (rawRed[0] & 0xFF) * 256 + (rawRed[1] & 0xFF);
    }

    public double getRawGreen() {
        byte[] rawGreen = new byte[2];
        if (this.m_mode == tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kRaw);
        }
        this.m_i2c.read(69, (byte)rawGreen.length, rawGreen);
        return (rawGreen[0] & 0xFF) * 256 + (rawGreen[1] & 0xFF);
    }

    public double getRawBlue() {
        byte[] rawBlue = new byte[2];
        if (this.m_mode == tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kRaw);
        }
        this.m_i2c.read(71, (byte)rawBlue.length, rawBlue);
        return (rawBlue[0] & 0xFF) * 256 + (rawBlue[1] & 0xFF);
    }

    public RGB getRawRGB() {
        byte[] colors = new byte[6];
        RGB result = new RGB();
        if (this.m_mode == tColorSensorMode.kActive.value) {
            this.setMode(tColorSensorMode.kRaw);
        }
        this.m_i2c.read(67, (byte)colors.length, colors);
        result.red = (colors[0] & 0xFF) * 256 + (colors[1] & 0xFF);
        result.green = (colors[2] & 0xFF) * 256 + (colors[3] & 0xFF);
        result.blue = (colors[4] & 0xFF) * 256 + (colors[5] & 0xFF);
        return result;
    }

    public void setMode(tColorSensorMode mode) {
        this.m_i2c.write(65, mode.value);
        this.m_mode = mode.value;
    }

    public String getSmartDashboardType() {
        return "Counter";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            if (this.rgbArray.size() == 0) {
                this.rgbArray.setSize(3);
            }
            if (this.m_mode == tColorSensorMode.kActive.value) {
                this.m_table.putNumber("Color", (double)this.getColor());
                this.rgbArray.set(0, (double)this.getRed());
                this.rgbArray.set(1, (double)this.getGreen());
                this.rgbArray.set(2, (double)this.getBlue());
                this.m_table.putValue("RGB", (Object)this.rgbArray);
            } else {
                this.m_table.putNumber("Color", 99.0);
                this.m_table.putValue("RGB", (Object)this.rgbArray);
            }
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }

    public static class tColorSensorMode {
        public final int value;
        static final int kActive_val = 0;
        static final int kPassive_val = 1;
        static final int kRaw_val = 3;
        public static final tColorSensorMode kActive = new tColorSensorMode(0);
        public static final tColorSensorMode kPassive = new tColorSensorMode(1);
        public static final tColorSensorMode kRaw = new tColorSensorMode(3);

        private tColorSensorMode(int value) {
            this.value = value;
        }
    }

    public class RGB {
        public double red;
        public double green;
        public double blue;

        public double getRed() {
            return this.red;
        }

        public double getGreen() {
            return this.green;
        }

        public double getBlue() {
            return this.blue;
        }
    }

    public class ColorSensorException
    extends RuntimeException {
        public ColorSensorException(String message) {
            super(message);
        }
    }
}

