/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.tables.ITable;

public class HiTechnicCompass
extends SensorBase
implements ISensor,
LiveWindowSendable,
PIDSource {
    private static final byte kAddress = 2;
    private static final byte kManufacturerBaseRegister = 8;
    private static final byte kManufacturerSize = 8;
    private static final byte kSensorTypeBaseRegister = 16;
    private static final byte kSensorTypeSize = 8;
    private static final byte kHeadingRegister = 68;
    private I2C m_i2c;
    private ITable m_table;

    public HiTechnicCompass(int slot) {
        DigitalModule module = DigitalModule.getInstance(slot);
        this.m_i2c = module.getI2C(2);
        byte[] kExpectedManufacturer = "HiTechnc".getBytes();
        byte[] kExpectedSensorType = "Compass ".getBytes();
        if (!this.m_i2c.verifySensor(8, 8, kExpectedManufacturer)) {
            throw new CompassException("Invalid Compass Manufacturer");
        }
        if (!this.m_i2c.verifySensor(16, 8, kExpectedSensorType)) {
            throw new CompassException("Invalid Sensor type");
        }
        UsageReporting.report(47, module.getModuleNumber() - 1);
        LiveWindow.addSensor("HiTechnicCompass", slot, 0, this);
    }

    public void free() {
        if (this.m_i2c != null) {
            this.m_i2c.free();
        }
        this.m_i2c = null;
    }

    public double getAngle() {
        byte[] heading = new byte[2];
        this.m_i2c.read(68, (byte)heading.length, heading);
        return heading[0] + heading[1] * 256;
    }

    public double pidGet() {
        return this.getAngle();
    }

    public String getSmartDashboardType() {
        return "Compass";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAngle());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }

    public class CompassException
    extends RuntimeException {
        public CompassException(String message) {
            super(message);
        }
    }
}

