/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;

public class IterativeRobot
extends RobotBase {
    private static final boolean TRACE_LOOP_ALLOCATIONS = false;
    private static final boolean TRACE_LOOP_ALLOCATIONS_AFTER_INIT = true;
    private boolean m_disabledInitialized = false;
    private boolean m_autonomousInitialized = false;
    private boolean m_teleopInitialized = false;
    private boolean m_testInitialized = false;
    private boolean dpFirstRun = true;
    private boolean apFirstRun = true;
    private boolean tpFirstRun = true;
    private boolean tmpFirstRun = true;

    public void startCompetition() {
        UsageReporting.report(22, 1);
        this.robotInit();
        int TRACE_LOOP_MAX = 100;
        int loopCount = 100;
        Object marker = null;
        boolean didDisabledPeriodic = false;
        boolean didAutonomousPeriodic = false;
        boolean didTeleopPeriodic = false;
        boolean didTestPeriodic = false;
        LiveWindow.setEnabled(false);
        while (true) {
            if (this.isDisabled()) {
                if (!this.m_disabledInitialized) {
                    LiveWindow.setEnabled(false);
                    this.disabledInit();
                    this.m_disabledInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_testInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    FRCControl.observeUserProgramDisabled();
                    this.disabledPeriodic();
                    didDisabledPeriodic = true;
                }
            } else if (this.isTest()) {
                if (!this.m_testInitialized) {
                    LiveWindow.setEnabled(true);
                    this.testInit();
                    this.m_testInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    FRCControl.observeUserProgramTest();
                    this.testPeriodic();
                    didTestPeriodic = true;
                }
            } else if (this.isAutonomous()) {
                if (!this.m_autonomousInitialized) {
                    LiveWindow.setEnabled(false);
                    this.autonomousInit();
                    this.m_autonomousInitialized = true;
                    this.m_testInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    this.getWatchdog().feed();
                    FRCControl.observeUserProgramAutonomous();
                    this.autonomousPeriodic();
                    didAutonomousPeriodic = true;
                }
            } else {
                if (!this.m_teleopInitialized) {
                    LiveWindow.setEnabled(false);
                    this.teleopInit();
                    this.m_teleopInitialized = true;
                    this.m_testInitialized = false;
                    this.m_autonomousInitialized = false;
                    this.m_disabledInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    this.getWatchdog().feed();
                    FRCControl.observeUserProgramTeleop();
                    this.teleopPeriodic();
                    didTeleopPeriodic = true;
                }
            }
            this.m_ds.waitForData();
        }
    }

    private boolean nextPeriodReady() {
        return this.m_ds.isNewControlData();
    }

    public void robotInit() {
        System.out.println("Default IterativeRobot.robotInit() method... Overload me!");
    }

    public void disabledInit() {
        System.out.println("Default IterativeRobot.disabledInit() method... Overload me!");
    }

    public void autonomousInit() {
        System.out.println("Default IterativeRobot.autonomousInit() method... Overload me!");
    }

    public void teleopInit() {
        System.out.println("Default IterativeRobot.teleopInit() method... Overload me!");
    }

    public void testInit() {
        System.out.println("Default IterativeRobot.testInit() method... Overload me!");
    }

    public void disabledPeriodic() {
        if (this.dpFirstRun) {
            System.out.println("Default IterativeRobot.disabledPeriodic() method... Overload me!");
            this.dpFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void autonomousPeriodic() {
        if (this.apFirstRun) {
            System.out.println("Default IterativeRobot.autonomousPeriodic() method... Overload me!");
            this.apFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void teleopPeriodic() {
        if (this.tpFirstRun) {
            System.out.println("Default IterativeRobot.teleopPeriodic() method... Overload me!");
            this.tpFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void testPeriodic() {
        if (this.tmpFirstRun) {
            System.out.println("Default IterativeRobot.testPeriodic() method... Overload me!");
            this.tmpFirstRun = false;
        }
    }
}

