/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Skeleton;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;

public class Kinect {
    private static Kinect m_instance;
    static final byte kHeaderBlockID = 19;
    static final byte kSkeletonExtraBlockID = 20;
    static final byte kSkeletonBlockID = 21;
    header_block_t m_headerData;
    skeletonExtra_block_t m_skeletonExtraData;
    skeleton_block_t m_skeletonData;
    boolean m_headerValid = false;
    boolean m_skeletonExtraValid = false;
    boolean m_skeletonValid = false;
    final Object m_headerDataSemaphore;
    final Object m_skeletonExtraDataSemaphore;
    final Object m_skeletonDataSemaphore;
    int m_recentPacketNumber = 0;
    header_block_t tempHeaderData = new header_block_t();
    skeletonExtra_block_t tempSkeletonExtraData = new skeletonExtra_block_t();
    skeleton_block_t tempSkeletonData = new skeleton_block_t();

    public static synchronized Kinect getInstance() {
        if (m_instance == null) {
            m_instance = new Kinect();
        }
        return m_instance;
    }

    Kinect() {
        this.m_headerData = new header_block_t();
        this.m_skeletonExtraData = new skeletonExtra_block_t();
        this.m_skeletonData = new skeleton_block_t();
        this.m_headerDataSemaphore = new Object();
        this.m_skeletonExtraDataSemaphore = new Object();
        this.m_skeletonDataSemaphore = new Object();
        UsageReporting.report(25, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateData() {
        if (this.m_recentPacketNumber != DriverStation.getInstance().getPacketNumber()) {
            int retVal;
            this.m_recentPacketNumber = DriverStation.getInstance().getPacketNumber();
            Object object = this.m_headerDataSemaphore;
            synchronized (object) {
                retVal = FRCControl.getDynamicControlData((byte)19, this.tempHeaderData, this.tempHeaderData.size(), 5);
                if (retVal == 0) {
                    this.tempHeaderData.copy(this.m_headerData);
                    this.m_headerValid = true;
                } else {
                    this.m_headerValid = false;
                }
            }
            object = this.m_skeletonExtraDataSemaphore;
            synchronized (object) {
                retVal = FRCControl.getDynamicControlData((byte)20, this.tempSkeletonExtraData, this.tempSkeletonExtraData.size(), 5);
                if (retVal == 0) {
                    this.tempSkeletonExtraData.copy(this.m_skeletonExtraData);
                    this.m_skeletonExtraValid = true;
                } else {
                    this.m_skeletonExtraValid = false;
                }
            }
            object = this.m_skeletonDataSemaphore;
            synchronized (object) {
                retVal = FRCControl.getDynamicControlData((byte)21, this.tempSkeletonData, this.tempSkeletonData.size(), 5);
                if (retVal == 0) {
                    this.tempSkeletonData.copy(this.m_skeletonData);
                    this.m_skeletonValid = true;
                } else {
                    this.m_skeletonValid = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPlayers() {
        this.updateData();
        if (!this.m_headerValid) {
            return 0;
        }
        Object object = this.m_headerDataSemaphore;
        synchronized (object) {
            return this.m_headerData.data.players;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point4 getFloorClipPlane() {
        this.updateData();
        Point4 tempClipPlane = new Point4();
        if (!this.m_headerValid) {
            return tempClipPlane;
        }
        Object object = this.m_headerDataSemaphore;
        synchronized (object) {
            tempClipPlane.x = this.m_headerData.data.floorClipPlane[0];
            tempClipPlane.y = this.m_headerData.data.floorClipPlane[1];
            tempClipPlane.z = this.m_headerData.data.floorClipPlane[2];
            tempClipPlane.w = this.m_headerData.data.floorClipPlane[3];
        }
        return tempClipPlane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point4 getGravityNormal() {
        this.updateData();
        Point4 tempGravityNormal = new Point4();
        if (!this.m_headerValid) {
            return tempGravityNormal;
        }
        Object object = this.m_headerDataSemaphore;
        synchronized (object) {
            tempGravityNormal.x = this.m_headerData.data.gravityNormalVector[0];
            tempGravityNormal.y = this.m_headerData.data.gravityNormalVector[1];
            tempGravityNormal.z = this.m_headerData.data.gravityNormalVector[2];
            tempGravityNormal.w = 0.0f;
        }
        return tempGravityNormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point4 getPosition() {
        this.updateData();
        Point4 tempPosition = new Point4();
        if (!this.m_skeletonExtraValid) {
            return tempPosition;
        }
        Object object = this.m_headerDataSemaphore;
        synchronized (object) {
            tempPosition.x = this.m_skeletonExtraData.data.position[0];
            tempPosition.y = this.m_skeletonExtraData.data.position[1];
            tempPosition.z = this.m_skeletonExtraData.data.position[2];
            tempPosition.w = 1.0f;
        }
        return tempPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skeleton getSkeleton() {
        int i;
        this.updateData();
        Skeleton tempSkeleton = new Skeleton();
        if (!this.m_skeletonValid) {
            return tempSkeleton;
        }
        Object object = this.m_skeletonDataSemaphore;
        synchronized (object) {
            for (i = 0; i < 20; ++i) {
                tempSkeleton.skeleton[i].x = this.m_skeletonData.data.vertices[i * 3];
                tempSkeleton.skeleton[i].y = this.m_skeletonData.data.vertices[i * 3 + 1];
                tempSkeleton.skeleton[i].z = this.m_skeletonData.data.vertices[i * 3 + 2];
            }
        }
        object = this.m_skeletonExtraDataSemaphore;
        synchronized (object) {
            for (i = 0; i < 20; ++i) {
                tempSkeleton.skeleton[i].trackingState = this.m_skeletonExtraData.data.trackingState[i];
            }
            switch (this.m_skeletonExtraData.data.trackState) {
                case 0: {
                    tempSkeleton.trackState = Skeleton.tTrackState.kNotTracked;
                    break;
                }
                case 1: {
                    tempSkeleton.trackState = Skeleton.tTrackState.kPositionOnly;
                    break;
                }
                case 2: {
                    tempSkeleton.trackState = Skeleton.tTrackState.kTracked;
                }
            }
        }
        return tempSkeleton;
    }

    class skeleton_block_t
    extends FRCControl.DynamicControlData {
        byte size = (byte)-15;
        byte id = (byte)21;
        skeleton_t data;

        skeleton_block_t() {
            this.allocateMemory();
            this.data = new skeleton_t(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), 240));
        }

        public void read() {
            this.size = this.backingNativeMemory.getByte(0L);
            this.id = this.backingNativeMemory.getByte(1L);
            this.data.read();
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.size);
            this.backingNativeMemory.setByte(1L, this.id);
            this.data.write();
        }

        public int size() {
            return 242;
        }

        public void copy(skeleton_block_t dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    class skeletonExtra_block_t
    extends FRCControl.DynamicControlData {
        byte size = (byte)41;
        byte id = (byte)20;
        skeletonExtra_t data;

        skeletonExtra_block_t() {
            this.allocateMemory();
            this.data = new skeletonExtra_t(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), 40));
        }

        public void read() {
            this.size = this.backingNativeMemory.getByte(0L);
            this.id = this.backingNativeMemory.getByte(1L);
            this.data.read();
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.size);
            this.backingNativeMemory.setByte(1L, this.id);
            this.data.write();
        }

        public int size() {
            return 42;
        }

        public void copy(skeletonExtra_block_t dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    class header_block_t
    extends FRCControl.DynamicControlData {
        byte size = (byte)45;
        byte id = (byte)19;
        header_t data;

        header_block_t() {
            this.allocateMemory();
            this.data = new header_t(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), 44));
        }

        public void read() {
            this.size = this.backingNativeMemory.getByte(0L);
            this.id = this.backingNativeMemory.getByte(1L);
            this.data.read();
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.size);
            this.backingNativeMemory.setByte(1L, this.id);
            this.data.write();
        }

        public int size() {
            return 46;
        }

        public void copy(header_block_t dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    static class skeleton_t
    extends Structure {
        float[] vertices = new float[60];
        static final int size = 240;

        skeleton_t(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.backingNativeMemory.getFloats(0L, this.vertices, 0, this.vertices.length);
        }

        public void write() {
            this.backingNativeMemory.setFloats(0L, this.vertices, 0, this.vertices.length);
        }

        public int size() {
            return 240;
        }
    }

    static class skeletonExtra_t
    extends Structure {
        byte[] trackingState = new byte[20];
        float[] position = new float[3];
        int quality;
        int trackState;
        static final int size = 40;

        skeletonExtra_t(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.backingNativeMemory.getBytes(0L, this.trackingState, 0, this.trackingState.length);
            this.backingNativeMemory.getFloats(20L, this.position, 0, this.position.length);
            this.quality = this.backingNativeMemory.getInt(32L);
            this.trackState = this.backingNativeMemory.getInt(36L);
        }

        public void write() {
            this.backingNativeMemory.setBytes(0L, this.trackingState, 0, this.trackingState.length);
            this.backingNativeMemory.setFloats(20L, this.position, 0, this.position.length);
            this.backingNativeMemory.setInt(32L, this.quality);
            this.backingNativeMemory.setInt(36L, this.trackState);
        }

        public int size() {
            return 40;
        }
    }

    static class header_t
    extends Structure {
        byte[] version = new byte[11];
        byte players;
        int flags;
        float[] floorClipPlane = new float[4];
        float[] gravityNormalVector = new float[3];
        static final int size = 44;

        header_t(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.backingNativeMemory.getBytes(0L, this.version, 0, this.version.length);
            this.players = this.backingNativeMemory.getByte(11L);
            this.flags = this.backingNativeMemory.getInt(12L);
            this.backingNativeMemory.getFloats(16L, this.floorClipPlane, 0, this.floorClipPlane.length);
            this.backingNativeMemory.getFloats(32L, this.gravityNormalVector, 0, this.gravityNormalVector.length);
        }

        public void write() {
            this.backingNativeMemory.setBytes(0L, this.version, 0, this.version.length);
            this.backingNativeMemory.setByte(11L, this.players);
            this.backingNativeMemory.setInt(12L, this.flags);
            this.backingNativeMemory.setFloats(16L, this.floorClipPlane, 0, this.floorClipPlane.length);
            this.backingNativeMemory.setFloats(32L, this.gravityNormalVector, 0, this.gravityNormalVector.length);
        }

        public int size() {
            return 44;
        }
    }

    public class Point4 {
        public float x;
        public float y;
        public float z;
        public float w;

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getW() {
            return this.w;
        }

        public int size() {
            return 16;
        }
    }
}

