/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;

public class KinectStick
extends GenericHID {
    private static final byte kJoystickDataID = 24;
    private static final byte kJoystickDataSize = 18;
    private int m_recentPacketNumber;
    private int m_id;
    JoystickData tempOutputData = new JoystickData();

    public KinectStick(int id) {
        this.m_id = id;
        UsageReporting.report(26, id);
    }

    private void getData() {
        if (this.m_recentPacketNumber != DriverStation.getInstance().getPacketNumber()) {
            this.m_recentPacketNumber = DriverStation.getInstance().getPacketNumber();
            int retVal = FRCControl.getDynamicControlData((byte)24, this.tempOutputData, this.tempOutputData.size(), 5);
            if (retVal != 0) {
                System.err.println("Bad retval: " + retVal);
            }
        }
    }

    private double normalize(byte rawValue) {
        if (rawValue >= 0) {
            return (double)rawValue / 127.0;
        }
        return (double)rawValue / 128.0;
    }

    public double getX(GenericHID.Hand hand) {
        this.getData();
        return this.getRawAxis(1);
    }

    public double getY(GenericHID.Hand hand) {
        this.getData();
        return this.getRawAxis(2);
    }

    public double getZ(GenericHID.Hand hand) {
        this.getData();
        return this.getRawAxis(3);
    }

    public double getTwist() {
        this.getData();
        return this.getRawAxis(3);
    }

    public double getThrottle() {
        this.getData();
        return this.getRawAxis(4);
    }

    public double getRawAxis(int axis) {
        if (axis < 1 || axis > 6) {
            return 0.0;
        }
        this.getData();
        if (this.m_id == 1) {
            return this.normalize(this.tempOutputData.data.joystick1[axis - 1]);
        }
        return this.normalize(this.tempOutputData.data.joystick2[axis - 1]);
    }

    public boolean getTrigger(GenericHID.Hand hand) {
        this.getData();
        return (this.tempOutputData.data.button1 & 1) != 0;
    }

    public boolean getTop(GenericHID.Hand hand) {
        this.getData();
        return (this.tempOutputData.data.button1 & 2) != 0;
    }

    public boolean getBumper(GenericHID.Hand hand) {
        this.getData();
        return (this.tempOutputData.data.button1 & 4) != 0;
    }

    public boolean getRawButton(int button) {
        this.getData();
        return (this.tempOutputData.data.button1 & (short)(1 << button - 1)) != 0;
    }

    class JoystickData
    extends FRCControl.DynamicControlData {
        JoystickDataBlock data;

        JoystickData() {
            this.allocateMemory();
            this.data = new JoystickDataBlock(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), 16));
        }

        public void read() {
            this.data.read();
        }

        public void write() {
            this.data.write();
        }

        public int size() {
            return 18;
        }

        public void copy(JoystickData dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    static class JoystickDataBlock
    extends Structure {
        byte[] joystick1 = new byte[6];
        short button1;
        byte[] joystick2 = new byte[6];
        short button2;
        public static final int size = 16;

        JoystickDataBlock(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.backingNativeMemory.getBytes(0L, this.joystick1, 0, 6);
            this.button1 = this.backingNativeMemory.getShort(6L);
            this.backingNativeMemory.getBytes(8L, this.joystick2, 0, 6);
            this.button2 = this.backingNativeMemory.getShort(14L);
        }

        public void write() {
            this.backingNativeMemory.setBytes(0L, this.joystick1, 0, 6);
            this.backingNativeMemory.setShort(6L, this.button1);
            this.backingNativeMemory.setBytes(8L, this.joystick2, 0, 6);
            this.backingNativeMemory.setShort(14L, this.button2);
        }

        public int size() {
            return 16;
        }
    }
}

