/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogModule;
import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.ModulePresence;

public class Module
extends SensorBase {
    protected static Module[] m_modules = new Module[ModulePresence.ModuleType.kSolenoid.getValue() * 2 + 1];
    protected int m_moduleNumber;
    protected ModulePresence.ModuleType m_moduleType;

    protected Module(ModulePresence.ModuleType moduleType, int moduleNumber) {
        Module.m_modules[Module.toIndex((ModulePresence.ModuleType)moduleType, (int)moduleNumber)] = this;
        this.m_moduleNumber = moduleNumber;
    }

    public int getModuleNumber() {
        return this.m_moduleNumber;
    }

    public ModulePresence.ModuleType getModuleType() {
        return this.m_moduleType;
    }

    public static Module getModule(ModulePresence.ModuleType moduleType, int moduleNumber) {
        if (m_modules[Module.toIndex(moduleType, moduleNumber)] == null) {
            if (moduleType.equals(ModulePresence.ModuleType.kAnalog)) {
                new AnalogModule(moduleNumber);
            } else if (moduleType.equals(ModulePresence.ModuleType.kDigital)) {
                new DigitalModule(moduleNumber);
            } else {
                throw new RuntimeException("A module of type " + moduleType + " with module index " + moduleNumber);
            }
        }
        return m_modules[Module.toIndex(moduleType, moduleNumber)];
    }

    private static int toIndex(ModulePresence.ModuleType moduleType, int moduleNumber) {
        if (moduleNumber == 0 || moduleNumber > 2) {
            return 0;
        }
        return moduleType.getValue() * 2 + (moduleNumber - 1);
    }
}

