/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Controller;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.IUtility;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.util.Timer;
import java.util.TimerTask;

public class PIDController
implements IUtility,
LiveWindowSendable,
Controller {
    public static final double kDefaultPeriod = 0.05;
    private static int instances = 0;
    private double m_P;
    private double m_I;
    private double m_D;
    private double m_F;
    private double m_maximumOutput = 1.0;
    private double m_minimumOutput = -1.0;
    private double m_maximumInput = 0.0;
    private double m_minimumInput = 0.0;
    private boolean m_continuous = false;
    private boolean m_enabled = false;
    private double m_prevError = 0.0;
    private double m_totalError = 0.0;
    private Tolerance m_tolerance;
    private double m_setpoint = 0.0;
    private double m_error = 0.0;
    private double m_result = 0.0;
    private double m_period = 0.05;
    PIDSource m_pidInput;
    PIDOutput m_pidOutput;
    Timer m_controlLoop;
    private boolean m_usingPercentTolerance;
    private ITableListener listener = new ITableListener(){

        public void valueChanged(ITable table, String key, Object value, boolean isNew) {
            if (key.equals("p") || key.equals("i") || key.equals("d") || key.equals("f")) {
                if (PIDController.this.m_P != table.getNumber("p", 0.0) || PIDController.this.m_I != table.getNumber("i", 0.0) || PIDController.this.m_D != table.getNumber("d", 0.0) || PIDController.this.m_F != table.getNumber("f", 0.0)) {
                    PIDController.this.setPID(table.getNumber("p", 0.0), table.getNumber("i", 0.0), table.getNumber("d", 0.0), table.getNumber("f", 0.0));
                }
            } else if (key.equals("setpoint")) {
                if (PIDController.this.m_setpoint != (Double)value) {
                    PIDController.this.setSetpoint((Double)value);
                }
            } else if (key.equals("enabled") && PIDController.this.m_enabled != (Boolean)value) {
                if (((Boolean)value).booleanValue()) {
                    PIDController.this.enable();
                } else {
                    PIDController.this.disable();
                }
            }
        }
    };
    private ITable table;

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output, double period) {
        if (source == null) {
            throw new NullPointerException("Null PIDSource was given");
        }
        if (output == null) {
            throw new NullPointerException("Null PIDOutput was given");
        }
        this.m_controlLoop = new Timer();
        this.m_P = Kp;
        this.m_I = Ki;
        this.m_D = Kd;
        this.m_F = Kf;
        this.m_pidInput = source;
        this.m_pidOutput = output;
        this.m_period = period;
        this.m_controlLoop.schedule((TimerTask)new PIDTask(this), 0L, (long)(this.m_period * 1000.0));
        UsageReporting.report(27, ++instances);
        this.m_tolerance = new NullTolerance();
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output, double period) {
        this(Kp, Ki, Kd, 0.0, source, output, period);
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, source, output, 0.05);
    }

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, Kf, source, output, 0.05);
    }

    public void free() {
        this.m_controlLoop.cancel();
        this.m_controlLoop = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() {
        PIDSource pidInput;
        boolean enabled;
        PIDController pIDController = this;
        synchronized (pIDController) {
            if (this.m_pidInput == null) {
                return;
            }
            if (this.m_pidOutput == null) {
                return;
            }
            enabled = this.m_enabled;
            pidInput = this.m_pidInput;
        }
        if (enabled) {
            double result;
            double input = pidInput.pidGet();
            PIDOutput pidOutput = null;
            PIDController pIDController2 = this;
            synchronized (pIDController2) {
                this.m_error = this.m_setpoint - input;
                if (this.m_continuous && Math.abs(this.m_error) > (this.m_maximumInput - this.m_minimumInput) / 2.0) {
                    this.m_error = this.m_error > 0.0 ? this.m_error - this.m_maximumInput + this.m_minimumInput : this.m_error + this.m_maximumInput - this.m_minimumInput;
                }
                if (this.m_I != 0.0) {
                    double potentialIGain = (this.m_totalError + this.m_error) * this.m_I;
                    this.m_totalError = potentialIGain < this.m_maximumOutput ? (potentialIGain > this.m_minimumOutput ? (this.m_totalError += this.m_error) : this.m_minimumOutput / this.m_I) : this.m_maximumOutput / this.m_I;
                }
                this.m_result = this.m_P * this.m_error + this.m_I * this.m_totalError + this.m_D * (this.m_error - this.m_prevError) + this.m_setpoint * this.m_F;
                this.m_prevError = this.m_error;
                if (this.m_result > this.m_maximumOutput) {
                    this.m_result = this.m_maximumOutput;
                } else if (this.m_result < this.m_minimumOutput) {
                    this.m_result = this.m_minimumOutput;
                }
                pidOutput = this.m_pidOutput;
                result = this.m_result;
            }
            pidOutput.pidWrite(result);
        }
    }

    public synchronized void setPID(double p, double i, double d) {
        this.m_P = p;
        this.m_I = i;
        this.m_D = d;
        if (this.table != null) {
            this.table.putNumber("p", p);
            this.table.putNumber("i", i);
            this.table.putNumber("d", d);
        }
    }

    public synchronized void setPID(double p, double i, double d, double f) {
        this.m_P = p;
        this.m_I = i;
        this.m_D = d;
        this.m_F = f;
        if (this.table != null) {
            this.table.putNumber("p", p);
            this.table.putNumber("i", i);
            this.table.putNumber("d", d);
            this.table.putNumber("f", f);
        }
    }

    public double getP() {
        return this.m_P;
    }

    public double getI() {
        return this.m_I;
    }

    public synchronized double getD() {
        return this.m_D;
    }

    public synchronized double getF() {
        return this.m_F;
    }

    public synchronized double get() {
        return this.m_result;
    }

    public synchronized void setContinuous(boolean continuous) {
        this.m_continuous = continuous;
    }

    public synchronized void setContinuous() {
        this.setContinuous(true);
    }

    public synchronized void setInputRange(double minimumInput, double maximumInput) {
        if (minimumInput > maximumInput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumInput = minimumInput;
        this.m_maximumInput = maximumInput;
        this.setSetpoint(this.m_setpoint);
    }

    public synchronized void setOutputRange(double minimumOutput, double maximumOutput) {
        if (minimumOutput > maximumOutput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumOutput = minimumOutput;
        this.m_maximumOutput = maximumOutput;
    }

    public synchronized void setSetpoint(double setpoint) {
        this.m_setpoint = this.m_maximumInput > this.m_minimumInput ? (setpoint > this.m_maximumInput ? this.m_maximumInput : (setpoint < this.m_minimumInput ? this.m_minimumInput : setpoint)) : setpoint;
        if (this.table != null) {
            this.table.putNumber("setpoint", this.m_setpoint);
        }
    }

    public synchronized double getSetpoint() {
        return this.m_setpoint;
    }

    public synchronized double getError() {
        return this.getSetpoint() - this.m_pidInput.pidGet();
    }

    public synchronized void setTolerance(double percent) {
        this.m_tolerance = new PercentageTolerance(percent);
    }

    private void setTolerance(Tolerance tolerance) {
        this.m_tolerance = tolerance;
    }

    public synchronized void setAbsoluteTolerance(double absvalue) {
        this.m_tolerance = new AbsoluteTolerance(absvalue);
    }

    public synchronized void setPercentTolerance(double percentage) {
        this.m_tolerance = new PercentageTolerance(percentage);
    }

    public synchronized boolean onTarget() {
        return this.m_tolerance.onTarget();
    }

    public synchronized void enable() {
        this.m_enabled = true;
        if (this.table != null) {
            this.table.putBoolean("enabled", true);
        }
    }

    public synchronized void disable() {
        this.m_pidOutput.pidWrite(0.0);
        this.m_enabled = false;
        if (this.table != null) {
            this.table.putBoolean("enabled", false);
        }
    }

    public synchronized boolean isEnable() {
        return this.m_enabled;
    }

    public synchronized void reset() {
        this.disable();
        this.m_prevError = 0.0;
        this.m_totalError = 0.0;
        this.m_result = 0.0;
    }

    public String getSmartDashboardType() {
        return "PIDController";
    }

    public void initTable(ITable table) {
        if (this.table != null) {
            this.table.removeTableListener(this.listener);
        }
        this.table = table;
        if (table != null) {
            table.putNumber("p", this.getP());
            table.putNumber("i", this.getI());
            table.putNumber("d", this.getD());
            table.putNumber("f", this.getF());
            table.putNumber("setpoint", this.getSetpoint());
            table.putBoolean("enabled", this.isEnable());
            table.addTableListener(this.listener, false);
        }
    }

    public ITable getTable() {
        return this.table;
    }

    public void updateTable() {
    }

    public void startLiveWindowMode() {
        this.disable();
    }

    public void stopLiveWindowMode() {
    }

    private class PIDTask
    extends TimerTask {
        private PIDController m_controller;

        public PIDTask(PIDController controller) {
            if (controller == null) {
                throw new NullPointerException("Given PIDController was null");
            }
            this.m_controller = controller;
        }

        public void run() {
            this.m_controller.calculate();
        }
    }

    public class NullTolerance
    implements Tolerance {
        public boolean onTarget() {
            throw new RuntimeException("No tolerance value set when using PIDController.onTarget()");
        }
    }

    public class AbsoluteTolerance
    implements Tolerance {
        double value;

        AbsoluteTolerance(double value) {
            this.value = value;
        }

        public boolean onTarget() {
            return Math.abs(PIDController.this.getError()) < this.value;
        }
    }

    public class PercentageTolerance
    implements Tolerance {
        double percentage;

        PercentageTolerance(double value) {
            this.percentage = value;
        }

        public boolean onTarget() {
            return Math.abs(PIDController.this.getError()) < this.percentage / 100.0 * (PIDController.this.m_maximumInput - PIDController.this.m_minimumInput);
        }
    }

    public static interface Tolerance {
        public boolean onTarget();
    }
}

