/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.squawk.microedition.io.FileConnection;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;

public class Preferences {
    private static final String TABLE_NAME = "Preferences";
    private static final String SAVE_FIELD = "~S A V E~";
    private static final String FILE_NAME = "file:///wpilib-preferences.ini";
    private static final byte[] VALUE_PREFIX = new byte[]{61, 34};
    private static final byte[] VALUE_SUFFIX = new byte[]{34, 10};
    private static final byte[] NEW_LINE = new byte[]{10};
    private static Preferences instance;
    private final Object fileLock = new Object();
    private final Object lock = new Object();
    private Hashtable values = new Hashtable();
    private Vector keys = new Vector();
    private Hashtable comments;
    private Comment endComment;

    public static synchronized Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences() {
        Object object = this.fileLock;
        synchronized (object) {
            new Thread(){

                public void run() {
                    Preferences.this.read();
                }
            }.start();
            try {
                this.fileLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        UsageReporting.report(28, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.keys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException();
            }
            ImproperPreferenceKeyException.confirmString(key);
            if (this.values.put(key, value) == null) {
                this.keys.addElement(key);
            }
            NetworkTable.getTable((String)TABLE_NAME).putString(key, value);
        }
    }

    public void putString(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.indexOf(34) != -1) {
            throw new IllegalArgumentException("Can not put string:" + value + " because it contains quotation marks");
        }
        this.put(key, value);
    }

    public void putInt(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void putLong(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException();
            }
            return (String)this.values.get(key);
        }
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.values.remove(key);
            this.keys.removeElement(key);
        }
    }

    public String getString(String key, String backup) {
        String value = this.get(key);
        return value == null ? backup : value;
    }

    public int getInt(String key, int backup) {
        String value = this.get(key);
        if (value == null) {
            return backup;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IncompatibleTypeException(value, "int");
        }
    }

    public double getDouble(String key, double backup) {
        String value = this.get(key);
        if (value == null) {
            return backup;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IncompatibleTypeException(value, "double");
        }
    }

    public boolean getBoolean(String key, boolean backup) {
        String value = this.get(key);
        if (value == null) {
            return backup;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IncompatibleTypeException(value, "boolean");
    }

    public float getFloat(String key, float backup) {
        String value = this.get(key);
        if (value == null) {
            return backup;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new IncompatibleTypeException(value, "float");
        }
    }

    public long getLong(String key, long backup) {
        String value = this.get(key);
        if (value == null) {
            this.put(key, String.valueOf(backup));
            return backup;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IncompatibleTypeException(value, "long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = this.fileLock;
        synchronized (object) {
            new Thread(){

                public void run() {
                    Preferences.this.write();
                }
            }.start();
            try {
                this.fileLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.fileLock;
            synchronized (object2) {
                this.fileLock.notifyAll();
            }
            FileConnection file = null;
            try {
                file = (FileConnection)Connector.open((String)FILE_NAME, (int)2);
                file.create();
                OutputStream output = file.openOutputStream();
                for (int i = 0; i < this.keys.size(); ++i) {
                    Comment comment;
                    String key = (String)this.keys.elementAt(i);
                    String value = (String)this.values.get(key);
                    if (this.comments != null && (comment = (Comment)this.comments.get(key)) != null) {
                        comment.write(output);
                    }
                    output.write(key.getBytes());
                    output.write(VALUE_PREFIX);
                    output.write(value.getBytes());
                    output.write(VALUE_SUFFIX);
                }
                if (this.endComment != null) {
                    this.endComment.write(output);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
                NetworkTable.getTable((String)TABLE_NAME).putBoolean(SAVE_FIELD, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        Object object = this.lock;
        synchronized (object) {
            FileConnection file;
            Comment comment;
            block28: {
                class EndOfStreamException
                extends Exception {
                    EndOfStreamException() {
                    }
                }
                Object object2 = this.fileLock;
                synchronized (object2) {
                    this.fileLock.notifyAll();
                }
                comment = null;
                file = null;
                try {
                    file = (FileConnection)Connector.open((String)FILE_NAME, (int)1);
                    if (!file.exists()) break block28;
                    class Reader {
                        InputStream stream;

                        Reader(InputStream stream) {
                            this.stream = stream;
                        }

                        public char read() throws IOException, EndOfStreamException {
                            int input = this.stream.read();
                            if (input == -1) {
                                throw new EndOfStreamException();
                            }
                            return (char)(input == 13 ? 10 : (char)input);
                        }

                        char readWithoutWhitespace() throws IOException, EndOfStreamException {
                            char value;
                            block3: while (true) {
                                value = this.read();
                                switch (value) {
                                    case '\t': 
                                    case ' ': {
                                        continue block3;
                                    }
                                }
                                break;
                            }
                            return value;
                        }
                    }
                    Reader reader = new Reader(file.openInputStream());
                    while (true) {
                        StringBuffer buffer;
                        char value;
                        if ((value = reader.readWithoutWhitespace()) == '\n' || value == ';') {
                            if (comment == null) {
                                comment = new Comment();
                            }
                            if (value == '\n') {
                                comment.addBytes(Preferences.NEW_LINE);
                                continue;
                            }
                            buffer = new StringBuffer(30);
                            while (value != '\n') {
                                buffer.append(value);
                                value = reader.read();
                            }
                            buffer.append('\n');
                            comment.addBytes(buffer.toString().getBytes());
                            continue;
                        }
                        buffer = new StringBuffer(30);
                        while (value != '=') {
                            buffer.append(value);
                            value = reader.readWithoutWhitespace();
                        }
                        String name = buffer.toString();
                        buffer = new StringBuffer(30);
                        boolean shouldBreak = false;
                        value = reader.readWithoutWhitespace();
                        if (value == '\"') {
                            value = reader.read();
                            while (value != '\"') {
                                buffer.append(value);
                                value = reader.read();
                            }
                            while (reader.read() != '\n') {
                            }
                        } else {
                            try {
                                while (value != '\n') {
                                    buffer.append(value);
                                    value = reader.readWithoutWhitespace();
                                }
                            }
                            catch (EndOfStreamException e) {
                                shouldBreak = true;
                            }
                        }
                        String result = buffer.toString();
                        this.keys.addElement(name);
                        this.values.put(name, result);
                        NetworkTable.getTable((String)TABLE_NAME).putString(name, result);
                        if (comment != null) {
                            if (this.comments == null) {
                                this.comments = new Hashtable();
                            }
                            this.comments.put(name, comment);
                            comment = null;
                        }
                        System.out.println(name + "=" + this.values.get(name));
                        if (shouldBreak) break;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (EndOfStreamException ex) {
                    System.out.println("Done Reading");
                }
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (comment != null) {
                this.endComment = comment;
            }
        }
        NetworkTable.getTable((String)TABLE_NAME).putBoolean(SAVE_FIELD, false);
        NetworkTable.getTable((String)TABLE_NAME).addTableListener(new ITableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ITable source, String key, Object value, boolean isNew) {
                if (key.equals(Preferences.SAVE_FIELD)) {
                    if (((Boolean)value).booleanValue()) {
                        Preferences.this.save();
                    }
                } else {
                    Object object = Preferences.this.lock;
                    synchronized (object) {
                        if (!ImproperPreferenceKeyException.isAcceptable(key) || value.toString().indexOf(34) != -1) {
                            if (Preferences.this.values.contains(key) || Preferences.this.keys.contains(key)) {
                                Preferences.this.values.remove(key);
                                Preferences.this.keys.removeElement(key);
                                NetworkTable.getTable((String)Preferences.TABLE_NAME).putString(key, "\"");
                            }
                        } else if (Preferences.this.values.put(key, value.toString()) == null) {
                            Preferences.this.keys.addElement(key);
                        }
                    }
                }
            }
        });
    }

    public static class ImproperPreferenceKeyException
    extends RuntimeException {
        public ImproperPreferenceKeyException(String value, char letter) {
            super("Preference key \"" + value + "\" is not allowed to contain letter with ASCII code:" + (byte)letter);
        }

        public static void confirmString(String value) {
            for (int i = 0; i < value.length(); ++i) {
                char letter = value.charAt(i);
                switch (letter) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '=': {
                        throw new ImproperPreferenceKeyException(value, letter);
                    }
                }
            }
        }

        public static boolean isAcceptable(String value) {
            for (int i = 0; i < value.length(); ++i) {
                char letter = value.charAt(i);
                switch (letter) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '=': {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class IncompatibleTypeException
    extends RuntimeException {
        public IncompatibleTypeException(String value, String type) {
            super("Cannot convert \"" + value + "\" into " + type);
        }
    }

    private static class Comment {
        private Vector bytes = new Vector();

        private Comment() {
        }

        private void addBytes(byte[] bytes) {
            this.bytes.addElement(bytes);
        }

        private void write(OutputStream stream) throws IOException {
            for (int i = 0; i < this.bytes.size(); ++i) {
                stream.write((byte[])this.bytes.elementAt(i));
            }
        }
    }
}

