/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.IDeviceController;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Relay
extends SensorBase
implements IDeviceController,
LiveWindowSendable {
    private int m_channel;
    private Direction m_direction;
    private DigitalModule m_module;
    private static Resource relayChannels = new Resource(32);
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initRelay(int moduleNumber) {
        SensorBase.checkRelayModule(moduleNumber);
        SensorBase.checkRelayChannel(this.m_channel);
        try {
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                relayChannels.allocate(((moduleNumber - 1) * 8 + this.m_channel - 1) * 2);
                UsageReporting.report(30, this.m_channel, moduleNumber - 1);
            }
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
                relayChannels.allocate(((moduleNumber - 1) * 8 + this.m_channel - 1) * 2 + 1);
                UsageReporting.report(30, this.m_channel + 128, moduleNumber - 1);
            }
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Relay channel " + this.m_channel + " on module " + moduleNumber + " is already allocated");
        }
        this.m_module = DigitalModule.getInstance(moduleNumber);
        this.m_module.setRelayForward(this.m_channel, false);
        this.m_module.setRelayReverse(this.m_channel, false);
        LiveWindow.addActuator("Relay", moduleNumber, this.m_channel, this);
    }

    public Relay(int moduleNumber, int channel, Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        this.m_channel = channel;
        this.m_direction = direction;
        this.initRelay(moduleNumber);
    }

    public Relay(int channel, Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        this.m_channel = channel;
        this.m_direction = direction;
        this.initRelay(Relay.getDefaultDigitalModule());
    }

    public Relay(int moduleNumber, int channel) {
        this.m_channel = channel;
        this.m_direction = Direction.kBoth;
        this.initRelay(moduleNumber);
    }

    public Relay(int channel) {
        this.m_channel = channel;
        this.m_direction = Direction.kBoth;
        this.initRelay(Relay.getDefaultDigitalModule());
    }

    public void free() {
        this.m_module.setRelayForward(this.m_channel, false);
        this.m_module.setRelayReverse(this.m_channel, false);
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
            relayChannels.free(((this.m_module.getModuleNumber() - 1) * 8 + this.m_channel - 1) * 2);
        }
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
            relayChannels.free(((this.m_module.getModuleNumber() - 1) * 8 + this.m_channel - 1) * 2 + 1);
        }
    }

    public void set(Value value) {
        switch (value.value) {
            case 0: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, false);
                break;
            }
            case 1: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, true);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, true);
                break;
            }
            case 2: {
                if (this.m_direction == Direction.kReverse) {
                    throw new InvalidValueException("A relay configured for reverse cannot be set to forward");
                }
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, true);
                }
                if (this.m_direction != Direction.kBoth) break;
                this.m_module.setRelayReverse(this.m_channel, false);
                break;
            }
            case 3: {
                if (this.m_direction == Direction.kForward) {
                    throw new InvalidValueException("A relay configured for forward cannot be set to reverse");
                }
                if (this.m_direction == Direction.kBoth) {
                    this.m_module.setRelayForward(this.m_channel, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, true);
                break;
            }
        }
    }

    public Value get() {
        if (this.m_module.getRelayForward(this.m_channel)) {
            if (this.m_module.getRelayReverse(this.m_channel)) {
                return Value.kOn;
            }
            if (this.m_direction == Direction.kForward) {
                return Value.kOn;
            }
            return Value.kForward;
        }
        if (this.m_module.getRelayReverse(this.m_channel)) {
            if (this.m_direction == Direction.kForward) {
                return Value.kOn;
            }
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        if (this.m_direction == direction) {
            return;
        }
        this.free();
        this.m_direction = direction;
        this.initRelay(this.m_module.getModuleNumber());
    }

    public String getSmartDashboardType() {
        return "Relay";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            if (this.get() == Value.kOn) {
                this.m_table.putString("Value", "On");
            } else if (this.get() == Value.kForward) {
                this.m_table.putString("Value", "Forward");
            } else if (this.get() == Value.kReverse) {
                this.m_table.putString("Value", "Reverse");
            } else {
                this.m_table.putString("Value", "Off");
            }
        }
    }

    public void startLiveWindowMode() {
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                String val = (String)value;
                if (val.equals("Off")) {
                    Relay.this.set(Value.kOff);
                } else if (val.equals("Forward")) {
                    Relay.this.set(Value.kForward);
                } else if (val.equals("Reverse")) {
                    Relay.this.set(Value.kReverse);
                }
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static class Direction {
        public final int value;
        static final int kBoth_val = 0;
        static final int kForward_val = 1;
        static final int kReverse_val = 2;
        public static final Direction kBoth = new Direction(0);
        public static final Direction kForward = new Direction(1);
        public static final Direction kReverse = new Direction(2);

        private Direction(int value) {
            this.value = value;
        }
    }

    public static class Value {
        public final int value;
        static final int kOff_val = 0;
        static final int kOn_val = 1;
        static final int kForward_val = 2;
        static final int kReverse_val = 3;
        public static final Value kOff = new Value(0);
        public static final Value kOn = new Value(1);
        public static final Value kForward = new Value(2);
        public static final Value kReverse = new Value(3);

        private Value(int value) {
            this.value = value;
        }
    }

    public class InvalidValueException
    extends RuntimeException {
        public InvalidValueException(String message) {
            super(message);
        }
    }
}

