/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.squawk.microedition.io.FileConnection;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Watchdog;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.microedition.io.Connector;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class RobotBase
extends MIDlet {
    public static final int ROBOT_TASK_PRIORITY = 101;
    public static final String ERRORS_TO_DRIVERSTATION_PROP = "first.driverstation.senderrors";
    protected static final String FILE_NAME = "file:///FRC_Lib_Version.ini";
    protected static final String VERSION_CONTENTS = "Java 2014 Update 0";
    protected final DriverStation m_ds;
    private final Watchdog m_watchdog = Watchdog.getInstance();

    protected RobotBase() {
        NetworkTable.setServerMode();
        this.m_ds = DriverStation.getInstance();
        this.m_watchdog.setEnabled(false);
        NetworkTable.getTable((String)"");
        NetworkTable.getTable((String)"LiveWindow").getSubTable("~STATUS~").putBoolean("LW Enabled", false);
    }

    public void free() {
    }

    public boolean isSystemActive() {
        return this.m_watchdog.isSystemActive();
    }

    public Watchdog getWatchdog() {
        return this.m_watchdog;
    }

    public static boolean isSimulation() {
        return false;
    }

    public static boolean isReal() {
        return true;
    }

    public boolean isDisabled() {
        return this.m_ds.isDisabled();
    }

    public boolean isEnabled() {
        return this.m_ds.isEnabled();
    }

    public boolean isAutonomous() {
        return this.m_ds.isAutonomous();
    }

    public boolean isTest() {
        return this.m_ds.isTest();
    }

    public boolean isOperatorControl() {
        return this.m_ds.isOperatorControl();
    }

    public boolean isNewDataAvailable() {
        return this.m_ds.isNewControlData();
    }

    public abstract void startCompetition();

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String propVal = System.getProperty(name);
        if (propVal == null) {
            return defaultValue;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalStateException(propVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeVersionString() {
        FileConnection file = null;
        try {
            file = (FileConnection)Connector.open((String)FILE_NAME, (int)2);
            file.create();
            OutputStream output = file.openOutputStream();
            PrintStream ps = new PrintStream(output);
            ps.println(VERSION_CONTENTS);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startApp() throws MIDletStateChangeException {
        boolean errorOnExit = false;
        Watchdog.getInstance().setExpiration(0.1);
        Watchdog.getInstance().setEnabled(false);
        FRCControl.observeUserProgramStarting();
        UsageReporting.report(2, 3);
        this.writeVersionString();
        try {
            this.startCompetition();
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorOnExit = true;
        }
        finally {
            System.err.println("WARNING: Robots don't quit!");
            if (errorOnExit) {
                System.err.println("---> The startCompetition() method (or methods called by it) should have handled the exception above.");
            } else {
                System.err.println("---> Unexpected return from startCompetition() method.");
            }
        }
    }

    protected final void pauseApp() {
    }

    protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }
}

