/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalOutput;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.fpga.tDIO;
import edu.wpi.first.wpilibj.fpga.tSPI;

public class SPIDevice
extends SensorBase {
    private static final Object semaphore = new Object();
    private static tSPI spi = null;
    private static boolean createdBusChannels = false;
    private static DigitalOutput clkChannel = null;
    private static DigitalOutput mosiChannel = null;
    private static DigitalInput misoChannel = null;
    private static int devices = 0;
    public static final boolean BIT_ORDER_MSB_FIRST = true;
    public static final boolean BIT_ORDER_LSB_FIRST = false;
    public static final boolean CLOCK_POLARITY_ACTIVE_HIGH = false;
    public static final boolean CLOCK_POLARITY_ACTIVE_LOW = true;
    public static final boolean DATA_ON_LEADING_EDGE = false;
    public static final boolean DATA_ON_TRAILING_EDGE = true;
    public static final boolean CS_ACTIVE_HIGH = true;
    public static final boolean CS_ACTIVE_LOW = false;
    public static final char FRAME_MODE_CHIP_SELECT = '\u0000';
    public static final char FRAME_MODE_PRE_LATCH = '\u0001';
    public static final char FRAME_MODE_POST_LATCH = '\u0002';
    public static final char FRAME_MODE_PRE_POST_LATCH_PULSE = '\u0003';
    private boolean createdCSChannel = false;
    private DigitalOutput cs = null;
    private boolean csActiveHigh;
    private boolean bitOrder = true;
    private boolean clockPolarity = false;
    private boolean dataOnTrailing = false;
    private int clockHalfPeriodDelay = 0;
    private char frameMode = '\u0000';
    public final double MAX_CLOCK_FREQUENCY = 1.0 / ((double)(2 * tDIO.readLoopTiming()) / 4.0E7);
    public final double MIN_CLOCK_FREQUENCY = 0.0 * ((double)(2 * tDIO.readLoopTiming()) / 4.0E7);

    private static void initBus(DigitalOutput clk, DigitalOutput mosi, DigitalInput miso) {
        if (spi != null) {
            if (clk.getChannel() == clkChannel.getChannel() && mosi.getChannel() == mosiChannel.getChannel() && miso.getChannel() == misoChannel.getChannel()) {
                return;
            }
            throw new BadSPIConfigException("SPI bus already configured with different clk, mosi and/or miso");
        }
        spi = new tSPI();
        clkChannel = clk;
        mosiChannel = mosi;
        misoChannel = miso;
        tSPI.writeChannels_SCLK_Module(clk.getModuleForRouting());
        tSPI.writeChannels_SCLK_Channel(clk.getChannelForRouting());
        if (mosi != null) {
            tSPI.writeChannels_MOSI_Module(mosi.getModuleForRouting());
            tSPI.writeChannels_MOSI_Channel(mosi.getChannelForRouting());
        } else {
            tSPI.writeChannels_MOSI_Module(0);
            tSPI.writeChannels_MOSI_Channel(0);
        }
        if (miso != null) {
            tSPI.writeChannels_MISO_Module(miso.getModuleForRouting());
            tSPI.writeChannels_MISO_Channel(miso.getChannelForRouting());
            tSPI.writeConfig_WriteOnly(false);
        } else {
            tSPI.writeChannels_MISO_Module(0);
            tSPI.writeChannels_MISO_Channel(0);
            tSPI.writeConfig_WriteOnly(true);
        }
        tSPI.writeChannels_SS_Module(0);
        tSPI.writeChannels_SS_Channel(0);
        tSPI.strobeReset();
        tSPI.strobeClearReceivedData();
    }

    private static void freeBus(boolean freeChannels) {
        if (spi != null) {
            spi.Release();
            spi = null;
        }
        if (freeChannels) {
            clkChannel.free();
            mosiChannel.free();
            misoChannel.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long trasferStatic(long value) {
        Object object = semaphore;
        synchronized (object) {
            tSPI.strobeClearReceivedData();
            tSPI.writeDataToLoad(value);
            tSPI.strobeLoad();
            if (!tSPI.readConfig_WriteOnly()) {
                while (tSPI.readReceivedElements() == 0) {
                    Thread.yield();
                }
                tSPI.strobeReadReceivedData();
                return tSPI.readReceivedData();
            }
            return 0L;
        }
    }

    public SPIDevice(int slot, int clkChannel, int mosiChannel, int misoChannel, int csChannel) {
        this(new DigitalOutput(slot, clkChannel), new DigitalOutput(slot, mosiChannel), new DigitalInput(slot, misoChannel), new DigitalOutput(slot, csChannel), false, true);
    }

    public SPIDevice(int slot, int clkChannel, int mosiChannel, int misoChannel, int csChannel, boolean csActiveHigh) {
        this(new DigitalOutput(slot, clkChannel), new DigitalOutput(slot, mosiChannel), new DigitalInput(slot, misoChannel), new DigitalOutput(slot, csChannel), csActiveHigh, true);
    }

    public SPIDevice(DigitalOutput clk, DigitalOutput mosi, DigitalInput miso, DigitalOutput cs) {
        this(clk, mosi, miso, cs, false, false);
    }

    public SPIDevice(DigitalOutput clk, DigitalOutput mosi, DigitalInput miso, DigitalOutput cs, boolean csActiveHigh) {
        this(clk, mosi, miso, cs, csActiveHigh, false);
    }

    public SPIDevice(int slot, int csChannel) {
        this(new DigitalOutput(slot, csChannel), false, true);
    }

    public SPIDevice(int slot, int csChannel, boolean csActiveHigh) {
        this(new DigitalOutput(slot, csChannel), csActiveHigh, true);
    }

    public SPIDevice(DigitalOutput cs) {
        this(cs, false);
    }

    public SPIDevice(DigitalOutput cs, boolean csActiveHigh) {
        this(cs, csActiveHigh, false);
    }

    private SPIDevice(DigitalOutput clk, DigitalOutput mosi, DigitalInput miso, DigitalOutput cs, boolean csActiveHigh, boolean createdChannel) {
        SPIDevice.initBus(clk, mosi, miso);
        ++devices;
        createdBusChannels = createdChannel;
        this.createdCSChannel = createdChannel;
        this.cs = cs;
        this.csActiveHigh = csActiveHigh;
        cs.set(!csActiveHigh);
        UsageReporting.report(35, devices);
    }

    private SPIDevice(DigitalOutput cs, boolean csActiveHigh, boolean createdChannel) {
        if (spi == null) {
            throw new RuntimeException("Must create SPI with clk, miso and mosi first");
        }
        this.createdCSChannel = createdChannel;
        this.cs = cs;
        this.csActiveHigh = csActiveHigh;
        cs.set(!csActiveHigh);
        UsageReporting.report(35, ++devices);
    }

    public void free() {
        if (this.createdCSChannel && this.cs != null) {
            this.cs.free();
        }
        if (--devices == 0) {
            SPIDevice.freeBus(createdBusChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transfer(long writeValue, int numBits) {
        long[] readValue;
        Object object = semaphore;
        synchronized (object) {
            readValue = this.transfer(new long[]{writeValue}, new int[]{numBits});
        }
        return readValue[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] transfer(long[] writeValues, int[] numBits) {
        if (writeValues.length != numBits.length) {
            throw new BadSPIConfigException("The number of values to write does not match array of data lengths");
        }
        for (int i = 0; i < numBits.length; ++i) {
            if (numBits[i] >= 1 && numBits[i] <= 32) continue;
            throw new BadSPIConfigException("All values in the data length must be >0 and <=32");
        }
        long[] readValues = new long[writeValues.length];
        Object object = semaphore;
        synchronized (object) {
            tSPI.writeConfig_MSBfirst(this.bitOrder);
            tSPI.writeConfig_ClockHalfPeriodDelay(this.clockHalfPeriodDelay);
            tSPI.writeConfig_ClockPolarity(this.clockPolarity);
            tSPI.writeConfig_DataOnFalling(this.dataOnTrailing);
            tSPI.writeConfig_FramePolarity(!this.csActiveHigh);
            this.writeFrameMode(this.frameMode);
            tSPI.writeChannels_SS_Module(this.cs.getModuleForRouting());
            tSPI.writeChannels_SS_Channel(this.cs.getChannelForRouting());
            for (int i = 0; i < writeValues.length; ++i) {
                tSPI.writeConfig_BusBitWidth(numBits[i]);
                readValues[i] = SPIDevice.trasferStatic(writeValues[i]);
            }
        }
        return readValues;
    }

    public final void setBitOrder(boolean bitOrder) {
        this.bitOrder = bitOrder;
    }

    public final void setClockPolarity(boolean clockPolarity) {
        this.clockPolarity = clockPolarity;
    }

    public final void setDataOnTrailing(boolean dataOnTrailing) {
        this.dataOnTrailing = dataOnTrailing;
    }

    public final void setFrameMode(char frameMode) {
        this.frameMode = frameMode;
    }

    public final void setClockRate(double hz) {
        double v = 1.0 / hz / ((double)(2 * tDIO.readLoopTiming()) / 4.0E7);
        if (v < 1.0) {
            throw new BadSPIConfigException("Clock Rate too high. Hz: " + hz);
        }
        int delay = (int)(v + 0.5);
        if (delay > 255) {
            throw new BadSPIConfigException("Clock Rate too low. Hz: " + hz);
        }
        this.clockHalfPeriodDelay = delay;
    }

    private void writeFrameMode(char frameMode) {
        switch (frameMode) {
            default: {
                tSPI.writeConfig_LatchFirst(false);
                tSPI.writeConfig_LatchLast(false);
                break;
            }
            case '\u0001': {
                tSPI.writeConfig_LatchFirst(true);
                tSPI.writeConfig_LatchLast(false);
                break;
            }
            case '\u0002': {
                tSPI.writeConfig_LatchFirst(false);
                tSPI.writeConfig_LatchLast(true);
                break;
            }
            case '\u0003': {
                tSPI.writeConfig_LatchFirst(true);
                tSPI.writeConfig_LatchLast(true);
            }
        }
    }

    public static class BadSPIConfigException
    extends RuntimeException {
        public BadSPIConfigException(String message) {
            super(message);
        }
    }
}

