/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.visa.Visa;
import edu.wpi.first.wpilibj.visa.VisaException;
import java.io.UnsupportedEncodingException;

public class SerialPort {
    private int m_resourceManagerHandle = Visa.viOpenDefaultRM();
    private int m_portHandle = Visa.viOpen(this.m_resourceManagerHandle, "ASRL1::INSTR", 0, 0);

    public SerialPort(int baudRate, int dataBits, Parity parity, StopBits stopBits) throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676321, baudRate);
        Visa.viSetAttribute(this.m_portHandle, 1073676322, dataBits);
        Visa.viSetAttribute(this.m_portHandle, 1073676323, parity.value);
        Visa.viSetAttribute(this.m_portHandle, 1073676324, stopBits.value);
        this.setReadBufferSize(1);
        this.setTimeout(5.0);
        this.setWriteBufferMode(WriteBufferMode.kFlushOnAccess);
        this.disableTermination();
        UsageReporting.report(32, 0);
    }

    public SerialPort(int baudRate, int dataBits, Parity parity) throws VisaException {
        this(baudRate, dataBits, parity, StopBits.kOne);
    }

    public SerialPort(int baudRate, int dataBits) throws VisaException {
        this(baudRate, dataBits, Parity.kNone, StopBits.kOne);
    }

    public SerialPort(int baudRate) throws VisaException {
        this(baudRate, 8, Parity.kNone, StopBits.kOne);
    }

    public void free() {
        Visa.viClose(this.m_portHandle);
        Visa.viClose(this.m_resourceManagerHandle);
    }

    public void setFlowControl(FlowControl flowControl) throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676325, flowControl.value);
    }

    public void enableTermination(char terminator) throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676344, true);
        Visa.viSetAttribute(this.m_portHandle, 1073676312, terminator);
        Visa.viSetAttribute(this.m_portHandle, 1073676467, 2);
    }

    public void enableTermination() throws VisaException {
        this.enableTermination('\n');
    }

    public void disableTermination() throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676344, false);
        Visa.viSetAttribute(this.m_portHandle, 1073676467, 0);
    }

    public int getBytesReceived() throws VisaException {
        return Visa.viGetAttribute(this.m_portHandle, 1073676460);
    }

    public void print(String write) throws VisaException {
        Visa.viVPrintf(this.m_portHandle, write);
    }

    public String readString() throws VisaException {
        return this.readString(this.getBytesReceived());
    }

    public String readString(int count) throws VisaException {
        byte[] out = Visa.viBufRead(this.m_portHandle, count);
        try {
            return new String(out, 0, count, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return new String();
        }
    }

    public byte[] read(int count) throws VisaException {
        return Visa.viBufRead(this.m_portHandle, count);
    }

    public int write(byte[] buffer, int count) throws VisaException {
        return Visa.viBufWrite(this.m_portHandle, buffer, count);
    }

    public void setTimeout(double timeout) throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676314, (int)(timeout * 1000.0));
    }

    void setReadBufferSize(int size) throws VisaException {
        Visa.viSetBuf(this.m_portHandle, (short)1, size);
    }

    void setWriteBufferSize(int size) throws VisaException {
        Visa.viSetBuf(this.m_portHandle, (short)2, size);
    }

    public void setWriteBufferMode(WriteBufferMode mode) throws VisaException {
        Visa.viSetAttribute(this.m_portHandle, 1073676333, mode.value);
    }

    public void flush() throws VisaException {
        Visa.viFlush(this.m_portHandle, (short)2);
    }

    public void reset() throws VisaException {
        Visa.viClear(this.m_portHandle);
    }

    public static class WriteBufferMode {
        public final int value;
        static final int kFlushOnAccess_val = 1;
        static final int kFlushWhenFull_val = 2;
        public static final WriteBufferMode kFlushOnAccess = new WriteBufferMode(1);
        public static final WriteBufferMode kFlushWhenFull = new WriteBufferMode(2);

        private WriteBufferMode(int value) {
            this.value = value;
        }
    }

    public static class FlowControl {
        public final int value;
        static final int kNone_val = 0;
        static final int kXonXoff_val = 1;
        static final int kRtsCts_val = 2;
        static final int kDtrDsr_val = 4;
        public static final FlowControl kNone = new FlowControl(0);
        public static final FlowControl kXonXoff = new FlowControl(1);
        public static final FlowControl kRtsCts = new FlowControl(2);
        public static final FlowControl kDtrDsr = new FlowControl(4);

        private FlowControl(int value) {
            this.value = value;
        }
    }

    public static class StopBits {
        public final int value;
        static final int kOne_val = 10;
        static final int kOnePointFive_val = 15;
        static final int kTwo_val = 20;
        public static final StopBits kOne = new StopBits(10);
        public static final StopBits kOnePointFive = new StopBits(15);
        public static final StopBits kTwo = new StopBits(20);

        private StopBits(int value) {
            this.value = value;
        }
    }

    public static class Parity {
        public final int value;
        static final int kNone_val = 0;
        static final int kOdd_val = 1;
        static final int kEven_val = 2;
        static final int kMark_val = 3;
        static final int kSpace_val = 4;
        public static final Parity kNone = new Parity(0);
        public static final Parity kOdd = new Parity(1);
        public static final Parity kEven = new Parity(2);
        public static final Parity kMark = new Parity(3);
        public static final Parity kSpace = new Parity(4);

        private Parity(int value) {
            this.value = value;
        }
    }
}

