/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.parsing.IDevice;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class Servo
extends PWM
implements IDevice {
    private static final double kMaxServoAngle = 170.0;
    private static final double kMinServoAngle = 0.0;
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initServo() {
        this.setBounds(2.27, 0.0, 0.0, 0.0, 0.743);
        this.setPeriodMultiplier(PWM.PeriodMultiplier.k4X);
        LiveWindow.addActuator("Servo", this.getModuleNumber(), this.getChannel(), this);
        UsageReporting.report(33, this.getChannel(), this.getModuleNumber() - 1);
    }

    public Servo(int channel) {
        super(channel);
        this.initServo();
    }

    public Servo(int slot, int channel) {
        super(slot, channel);
        this.initServo();
    }

    public void set(double value) {
        this.setPosition(value);
    }

    public double get() {
        return this.getPosition();
    }

    public void setAngle(double degrees) {
        if (degrees < 0.0) {
            degrees = 0.0;
        } else if (degrees > 170.0) {
            degrees = 170.0;
        }
        this.setPosition((degrees - 0.0) / this.getServoAngleRange());
    }

    public double getAngle() {
        return this.getPosition() * this.getServoAngleRange() + 0.0;
    }

    private double getServoAngleRange() {
        return 170.0;
    }

    public String getSmartDashboardType() {
        return "Servo";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    public void startLiveWindowMode() {
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                Servo.this.set((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_table_listener);
    }
}

