/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tSolenoid;
import edu.wpi.first.wpilibj.parsing.IDeviceController;

public abstract class SolenoidBase
extends SensorBase
implements IDeviceController {
    protected int m_moduleNumber;
    protected static Resource m_allocated = new Resource(16);
    private static tSolenoid m_fpgaSolenoidModule;
    private static int m_refCount;

    public SolenoidBase(int moduleNumber) {
        this.m_moduleNumber = moduleNumber;
        SolenoidBase.checkSolenoidModule(this.m_moduleNumber);
        if (++m_refCount == 1) {
            m_fpgaSolenoidModule = new tSolenoid();
        }
    }

    public synchronized void free() {
        if (m_refCount == 1) {
            m_fpgaSolenoidModule.Release();
            m_fpgaSolenoidModule = null;
        }
        --m_refCount;
    }

    protected synchronized void set(int value, int mask) {
        byte currentValue = (byte)tSolenoid.readDO7_0(this.m_moduleNumber - 1);
        currentValue = (byte)(currentValue & ~mask);
        currentValue = (byte)(currentValue | value & mask);
        tSolenoid.writeDO7_0(this.m_moduleNumber - 1, currentValue);
    }

    public byte getAll() {
        return (byte)tSolenoid.readDO7_0(this.m_moduleNumber - 1);
    }

    public static byte getAllFromDefaultModule() {
        return SolenoidBase.getAllFromModule(SolenoidBase.getDefaultSolenoidModule());
    }

    public static byte getAllFromModule(int moduleNumber) {
        SolenoidBase.checkSolenoidModule(moduleNumber);
        return (byte)tSolenoid.readDO7_0(moduleNumber - 1);
    }
}

