/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.tables.ITable;

public class Ultrasonic
extends SensorBase
implements PIDSource,
ISensor,
LiveWindowSendable {
    private static final double kPingTime = 9.999999999999999E-6;
    private static final int kPriority = 90;
    private static final double kMaxUltrasonicTime = 0.1;
    private static final double kSpeedOfSoundInchesPerSec = 13560.0;
    private static Ultrasonic m_firstSensor = null;
    private static boolean m_automaticEnabled = false;
    private DigitalInput m_echoChannel = null;
    private DigitalOutput m_pingChannel = null;
    private boolean m_allocatedChannels;
    private boolean m_enabled = false;
    private Counter m_counter = null;
    private Ultrasonic m_nextSensor = null;
    private static Thread m_task = null;
    private Unit m_units;
    private static int m_instances = 0;
    private ITable m_table;

    private synchronized void initialize() {
        if (m_task == null) {
            m_task = new UltrasonicChecker();
        }
        boolean originalMode = m_automaticEnabled;
        this.setAutomaticMode(false);
        this.m_nextSensor = m_firstSensor;
        m_firstSensor = this;
        this.m_counter = new Counter(this.m_echoChannel);
        this.m_counter.setMaxPeriod(1.0);
        this.m_counter.setSemiPeriodMode(true);
        this.m_counter.reset();
        this.m_counter.start();
        this.m_enabled = true;
        this.setAutomaticMode(originalMode);
        UsageReporting.report(37, ++m_instances);
        LiveWindow.addSensor("Ultrasonic", this.m_echoChannel.getModuleForRouting(), this.m_echoChannel.getChannel(), this);
    }

    public Ultrasonic(int pingChannel, int echoChannel, Unit units) {
        this.m_pingChannel = new DigitalOutput(pingChannel);
        this.m_echoChannel = new DigitalInput(echoChannel);
        this.m_allocatedChannels = true;
        this.m_units = units;
        this.initialize();
    }

    public Ultrasonic(int pingChannel, int echoChannel) {
        this(pingChannel, echoChannel, Unit.kInches);
    }

    public Ultrasonic(DigitalOutput pingChannel, DigitalInput echoChannel, Unit units) {
        if (pingChannel == null || echoChannel == null) {
            throw new NullPointerException("Null Channel Provided");
        }
        this.m_allocatedChannels = false;
        this.m_pingChannel = pingChannel;
        this.m_echoChannel = echoChannel;
        this.m_units = units;
        this.initialize();
    }

    public Ultrasonic(DigitalOutput pingChannel, DigitalInput echoChannel) {
        this(pingChannel, echoChannel, Unit.kInches);
    }

    public Ultrasonic(int pingSlot, int pingChannel, int echoSlot, int echoChannel, Unit units) {
        this.m_pingChannel = new DigitalOutput(pingSlot, pingChannel);
        this.m_echoChannel = new DigitalInput(echoSlot, echoChannel);
        this.m_allocatedChannels = true;
        this.m_units = units;
        this.initialize();
    }

    public Ultrasonic(int pingSlot, int pingChannel, int echoSlot, int echoChannel) {
        this(pingSlot, pingChannel, echoSlot, echoChannel, Unit.kInches);
    }

    public synchronized void free() {
        boolean wasAutomaticMode = m_automaticEnabled;
        this.setAutomaticMode(false);
        if (this.m_allocatedChannels) {
            if (this.m_pingChannel != null) {
                this.m_pingChannel.free();
            }
            if (this.m_echoChannel != null) {
                this.m_echoChannel.free();
            }
        }
        if (this.m_counter != null) {
            this.m_counter.free();
            this.m_counter = null;
        }
        this.m_pingChannel = null;
        this.m_echoChannel = null;
        if (this == m_firstSensor) {
            m_firstSensor = this.m_nextSensor;
            if (m_firstSensor == null) {
                this.setAutomaticMode(false);
            }
        } else {
            Ultrasonic s = m_firstSensor;
            while (s != null) {
                if (this == s.m_nextSensor) {
                    s.m_nextSensor = s.m_nextSensor.m_nextSensor;
                    break;
                }
                s = s.m_nextSensor;
            }
        }
        if (m_firstSensor != null && wasAutomaticMode) {
            this.setAutomaticMode(true);
        }
    }

    public void setAutomaticMode(boolean enabling) {
        if (enabling == m_automaticEnabled) {
            return;
        }
        m_automaticEnabled = enabling;
        if (enabling) {
            Ultrasonic u = m_firstSensor;
            while (u != null) {
                u.m_counter.reset();
                u = u.m_nextSensor;
            }
            m_task.start();
        } else {
            while (m_task.isAlive()) {
                Timer.delay(0.15);
            }
            Ultrasonic u = m_firstSensor;
            while (u != null) {
                u.m_counter.reset();
                u = u.m_nextSensor;
            }
        }
    }

    public void ping() {
        this.setAutomaticMode(false);
        this.m_counter.reset();
        this.m_pingChannel.pulse(9.999999999999999E-6);
    }

    public boolean isRangeValid() {
        return this.m_counter.get() > 1;
    }

    public double getRangeInches() {
        if (this.isRangeValid()) {
            return this.m_counter.getPeriod() * 13560.0 / 2.0;
        }
        return 0.0;
    }

    public double getRangeMM() {
        return this.getRangeInches() * 25.4;
    }

    public double pidGet() {
        switch (this.m_units.value) {
            case 0: {
                return this.getRangeInches();
            }
            case 1: {
                return this.getRangeMM();
            }
        }
        return 0.0;
    }

    public void setDistanceUnits(Unit units) {
        this.m_units = units;
    }

    public Unit getDistanceUnits() {
        return this.m_units;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enable) {
        this.m_enabled = enable;
    }

    public String getSmartDashboardType() {
        return "Ultrasonic";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getRangeInches());
        }
    }

    public void startLiveWindowMode() {
    }

    public void stopLiveWindowMode() {
    }

    private class UltrasonicChecker
    extends Thread {
        private UltrasonicChecker() {
        }

        public synchronized void run() {
            Ultrasonic u = null;
            while (m_automaticEnabled) {
                if (u == null) {
                    u = m_firstSensor;
                }
                if (u == null) {
                    return;
                }
                if (u.isEnabled()) {
                    u.m_pingChannel.pulse(9.999999999999999E-6);
                }
                u = u.m_nextSensor;
                Timer.delay(0.1);
            }
        }
    }

    public static class Unit {
        public final int value;
        static final int kInches_val = 0;
        static final int kMillimeters_val = 1;
        public static final Unit kInches = new Unit(0);
        public static final Unit kMillimeter = new Unit(1);

        private Unit(int value) {
            this.value = value;
        }
    }
}

