/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.buttons;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.tables.ITable;

public abstract class Trigger
implements Sendable {
    private ITable table;

    public abstract boolean get();

    private boolean grab() {
        return this.get() || this.table != null && this.table.getBoolean("pressed", false);
    }

    public void whenActive(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Trigger.this.grab();
            }

            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.pressedLast) {
                        this.pressedLast = true;
                        command.start();
                    }
                } else {
                    this.pressedLast = false;
                }
            }
        }.start();
    }

    public void whileActive(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Trigger.this.grab();
            }

            public void execute() {
                if (Trigger.this.grab()) {
                    this.pressedLast = true;
                    command.start();
                } else if (this.pressedLast) {
                    this.pressedLast = false;
                    command.cancel();
                }
            }
        }.start();
    }

    public void whenInactive(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Trigger.this.grab();
            }

            public void execute() {
                if (Trigger.this.grab()) {
                    this.pressedLast = true;
                } else if (this.pressedLast) {
                    this.pressedLast = false;
                    command.start();
                }
            }
        }.start();
    }

    public void toggleWhenActive(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Trigger.this.grab();
            }

            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.pressedLast) {
                        this.pressedLast = true;
                        if (command.isRunning()) {
                            command.cancel();
                        } else {
                            command.start();
                        }
                    }
                } else {
                    this.pressedLast = false;
                }
            }
        }.start();
    }

    public void cancelWhenActive(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Trigger.this.grab();
            }

            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.pressedLast) {
                        this.pressedLast = true;
                        command.cancel();
                    }
                } else {
                    this.pressedLast = false;
                }
            }
        }.start();
    }

    public String getSmartDashboardType() {
        return "Button";
    }

    public void initTable(ITable table) {
        this.table = table;
        if (table != null) {
            table.putBoolean("pressed", this.get());
        }
    }

    public ITable getTable() {
        return this.table;
    }

    public abstract class ButtonScheduler {
        public abstract void execute();

        protected void start() {
            Scheduler.getInstance().addButton(this);
        }
    }
}

