/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.camera;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.TaskExecutor;
import com.sun.squawk.VM;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.camera.AxisCameraException;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.image.ColorImage;
import edu.wpi.first.wpilibj.image.HSLImage;
import edu.wpi.first.wpilibj.image.NIVisionException;
import edu.wpi.first.wpilibj.parsing.ISensor;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class AxisCamera
implements ISensor {
    private static AxisCamera m_instance = null;
    private static final Function cameraStartFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraStart");
    private static final TaskExecutor cameraTaskExecutor = new TaskExecutor("camera task executor");
    private static final BlockingFunction getImageFn = NativeLibrary.getDefaultInstance().getBlockingFunction("AxisCameraGetImage");
    private static final Function writeBrightnessFn;
    private static final Function getBrightnessFn;
    private static final Function writeWhiteBalenceFn;
    private static final Function getWhiteBalanceFn;
    private static final Function writeColorLevelFn;
    private static final Function getColorLevelFn;
    private static final Function writeExposureControlFn;
    private static final Function getExposureControlFn;
    private static final Function writeExposurePriorityFn;
    private static final Function getExposurePriorityFn;
    private static final Function writeResolutionFn;
    private static final Function getResolutionFn;
    private static final Function writeCompressionFn;
    private static final Function getCompressionFn;
    private static final Function writeRotationFn;
    private static final Function getRotationFn;
    private static final Function freshImageFn;
    private static final Function getMaxFPSFn;
    private static final Function writeMaxFPSFn;
    private static final Function deleteInstanceFn;

    public static synchronized AxisCamera getInstance(String address) {
        if (m_instance == null) {
            m_instance = new AxisCamera(address);
            UsageReporting.report(41, 2);
        }
        return m_instance;
    }

    public static synchronized AxisCamera getInstance() {
        if (m_instance == null) {
            DriverStation.getInstance().waitForData();
            int teamNumber = DriverStation.getInstance().getTeamNumber();
            String address = "10." + teamNumber / 100 + "." + teamNumber % 100 + ".11";
            m_instance = new AxisCamera(address);
            UsageReporting.report(41, 1);
        }
        return m_instance;
    }

    AxisCamera(String IPAddress) {
        Pointer ptr = Pointer.createStringBuffer((String)IPAddress);
        cameraStartFn.call1(ptr);
    }

    public ColorImage getImage() throws AxisCameraException, NIVisionException {
        HSLImage image = new HSLImage();
        if (getImageFn.call1(image.image) == 0) {
            image.free();
            throw new AxisCameraException("No image available");
        }
        return image;
    }

    public void writeBrightness(int brightness) {
        BoundaryException.assertWithinBounds(brightness, 0.0, 100.0);
        writeBrightnessFn.call1(brightness);
    }

    public int getBrightness() {
        return getBrightnessFn.call0();
    }

    public void writeWhiteBalance(WhiteBalanceT whiteBalance) {
        writeWhiteBalenceFn.call1(whiteBalance.value);
    }

    public WhiteBalanceT getWhiteBalance() {
        return WhiteBalanceT.get(AxisCamera.getWhiteBalanceFn.call0());
    }

    public void writeColorLevel(int value) {
        BoundaryException.assertWithinBounds(value, 0.0, 100.0);
        writeColorLevelFn.call1(value);
    }

    public int getColorLevel() {
        return getColorLevelFn.call0();
    }

    public void writeExposureControl(ExposureT value) {
        writeExposureControlFn.call1(value.value);
    }

    public ExposureT getExposureControl() {
        return ExposureT.get(AxisCamera.getExposureControlFn.call0());
    }

    public void writeExposurePriority(ExposurePriorityT value) {
        writeExposurePriorityFn.call1(value.value);
    }

    public ExposurePriorityT getExposurePriority() {
        return ExposurePriorityT.get(AxisCamera.getExposurePriorityFn.call0());
    }

    public void writeResolution(ResolutionT value) {
        writeResolutionFn.call1(value.value);
    }

    public ResolutionT getResolution() {
        return ResolutionT.get(AxisCamera.getResolutionFn.call0());
    }

    public void writeCompression(int value) {
        BoundaryException.assertWithinBounds(value, 0.0, 100.0);
        writeCompressionFn.call1(value);
    }

    public int getCompression() {
        return getCompressionFn.call0();
    }

    public void writeRotation(RotationT value) {
        writeRotationFn.call1(value.value);
    }

    public RotationT getRotation() {
        return RotationT.get(AxisCamera.getRotationFn.call0());
    }

    public boolean freshImage() {
        return freshImageFn.call0() != 0;
    }

    public int getMaxFPS() {
        return getMaxFPSFn.call0();
    }

    public void writeMaxFPS(int value) {
        writeMaxFPSFn.call1(value);
    }

    static {
        getImageFn.setTaskExecutor(cameraTaskExecutor);
        writeBrightnessFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteBrightness");
        getBrightnessFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetBrightness");
        writeWhiteBalenceFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteWhiteBalance");
        getWhiteBalanceFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetWhiteBalance");
        writeColorLevelFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteColorLevel");
        getColorLevelFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetColorLevel");
        writeExposureControlFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteExposureControl");
        getExposureControlFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetExposureControl");
        writeExposurePriorityFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteExposurePriority");
        getExposurePriorityFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetExposurePriority");
        writeResolutionFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteResolution");
        getResolutionFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetResolution");
        writeCompressionFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteCompression");
        getCompressionFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetCompression");
        writeRotationFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteRotation");
        getRotationFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetRotation");
        freshImageFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraFreshImage");
        getMaxFPSFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraGetMaxFPS");
        writeMaxFPSFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraWriteMaxFPS");
        deleteInstanceFn = NativeLibrary.getDefaultInstance().getFunction("AxisCameraDeleteInstance");
        VM.addShutdownHook((Thread)new Thread(){

            public void run() {
                deleteInstanceFn.call0();
            }
        });
    }

    public static class ExposurePriorityT {
        public final int value;
        static final ExposurePriorityT[] allValues = new ExposurePriorityT[3];
        public static final ExposurePriorityT imageQuality = new ExposurePriorityT(0);
        public static final ExposurePriorityT none = new ExposurePriorityT(50);
        public static final ExposurePriorityT frameRate = new ExposurePriorityT(100);

        private ExposurePriorityT(int value) {
            this.value = value;
            ExposurePriorityT.allValues[value / 50] = this;
        }

        private static ExposurePriorityT get(int value) {
            return allValues[value / 50];
        }
    }

    public static class RotationT {
        public final int value;
        static final RotationT[] allValues = new RotationT[2];
        public static final RotationT k0 = new RotationT(0);
        public static final RotationT k180 = new RotationT(1);

        private RotationT(int value) {
            this.value = value;
            RotationT.allValues[value] = this;
        }

        private static RotationT get(int value) {
            return allValues[value];
        }
    }

    public static class ResolutionT {
        public final int value;
        public final int width;
        public final int height;
        static final ResolutionT[] allValues = new ResolutionT[4];
        public static final ResolutionT k640x480 = new ResolutionT(0, 640, 480);
        public static final ResolutionT k640x360 = new ResolutionT(1, 640, 360);
        public static final ResolutionT k320x240 = new ResolutionT(2, 320, 240);
        public static final ResolutionT k160x120 = new ResolutionT(3, 160, 120);

        private ResolutionT(int value, int horizontal, int vertical) {
            this.value = value;
            this.width = horizontal;
            this.height = vertical;
            ResolutionT.allValues[value] = this;
        }

        private static ResolutionT get(int value) {
            return allValues[value];
        }
    }

    public static class WhiteBalanceT {
        public final int value;
        static final WhiteBalanceT[] allValues = new WhiteBalanceT[7];
        public static final WhiteBalanceT automatic = new WhiteBalanceT(0);
        public static final WhiteBalanceT hold = new WhiteBalanceT(1);
        public static final WhiteBalanceT fixedOutdoor1 = new WhiteBalanceT(2);
        public static final WhiteBalanceT fixedOutdoor2 = new WhiteBalanceT(3);
        public static final WhiteBalanceT fixedIndoor = new WhiteBalanceT(4);
        public static final WhiteBalanceT fixedFlour1 = new WhiteBalanceT(5);
        public static final WhiteBalanceT fixedFlour2 = new WhiteBalanceT(6);

        private WhiteBalanceT(int value) {
            this.value = value;
            WhiteBalanceT.allValues[value] = this;
        }

        private static WhiteBalanceT get(int value) {
            return allValues[value];
        }
    }

    public static class ExposureT {
        public final int value;
        static final ExposureT[] allValues = new ExposureT[4];
        public static final ExposureT automatic = new ExposureT(0);
        public static final ExposureT hold = new ExposureT(1);
        public static final ExposureT flickerfree50 = new ExposureT(2);
        public static final ExposureT flickerfree60 = new ExposureT(3);

        private ExposureT(int value) {
            this.value = value;
            ExposureT.allValues[value] = this;
        }

        private static ExposureT get(int val) {
            return allValues[val];
        }
    }
}

