/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.buttons.Trigger;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.LinkedListElement;
import edu.wpi.first.wpilibj.command.Set;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Scheduler
implements NamedSendable {
    private static Scheduler instance;
    private Hashtable commandTable = new Hashtable();
    private Set subsystems = new Set();
    private LinkedListElement firstCommand;
    private LinkedListElement lastCommand;
    private boolean adding = false;
    private boolean disabled = false;
    private Vector additions = new Vector();
    private ITable m_table;
    private Vector buttons;
    private boolean m_runningCommandsChanged;
    private StringArray commands;
    private NumberArray ids;
    private NumberArray toCancel;

    public static synchronized Scheduler getInstance() {
        return instance == null ? (instance = new Scheduler()) : instance;
    }

    private Scheduler() {
        UsageReporting.report(40, 1);
    }

    public void add(Command command) {
        if (command != null) {
            this.additions.addElement(command);
        }
    }

    public void addButton(Trigger.ButtonScheduler button) {
        if (this.buttons == null) {
            this.buttons = new Vector();
        }
        this.buttons.addElement(button);
    }

    private void _add(Command command) {
        if (command == null) {
            return;
        }
        if (this.adding) {
            System.err.println("WARNING: Can not start command from cancel method.  Ignoring:" + command);
            return;
        }
        if (!this.commandTable.containsKey(command)) {
            Subsystem lock;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() == null || lock.getCurrentCommand().isInterruptible()) continue;
                return;
            }
            this.adding = true;
            requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() != null) {
                    lock.getCurrentCommand().cancel();
                    this.remove(lock.getCurrentCommand());
                }
                lock.setCurrentCommand(command);
            }
            this.adding = false;
            LinkedListElement element = new LinkedListElement();
            element.setData(command);
            if (this.firstCommand == null) {
                this.firstCommand = this.lastCommand = element;
            } else {
                this.lastCommand.add(element);
                this.lastCommand = element;
            }
            this.commandTable.put(command, element);
            this.m_runningCommandsChanged = true;
            command.startRunning();
        }
    }

    public void run() {
        this.m_runningCommandsChanged = false;
        if (this.disabled) {
            return;
        }
        if (this.buttons != null) {
            for (int i = this.buttons.size() - 1; i >= 0; --i) {
                ((Trigger.ButtonScheduler)this.buttons.elementAt(i)).execute();
            }
        }
        for (LinkedListElement e = this.firstCommand; e != null; e = e.getNext()) {
            Command c = e.getData();
            if (c.run()) continue;
            this.remove(c);
            this.m_runningCommandsChanged = true;
        }
        for (int i = 0; i < this.additions.size(); ++i) {
            this._add((Command)this.additions.elementAt(i));
        }
        this.additions.removeAllElements();
        Enumeration locks = this.subsystems.getElements();
        while (locks.hasMoreElements()) {
            Subsystem lock = (Subsystem)locks.nextElement();
            if (lock.getCurrentCommand() == null) {
                this._add(lock.getDefaultCommand());
            }
            lock.confirmCommand();
        }
        this.updateTable();
    }

    void registerSubsystem(Subsystem system) {
        if (system != null) {
            this.subsystems.add(system);
        }
    }

    void remove(Command command) {
        if (command == null || !this.commandTable.containsKey(command)) {
            return;
        }
        LinkedListElement e = (LinkedListElement)this.commandTable.get(command);
        this.commandTable.remove(command);
        if (e.equals(this.lastCommand)) {
            this.lastCommand = e.getPrevious();
        }
        if (e.equals(this.firstCommand)) {
            this.firstCommand = e.getNext();
        }
        e.remove();
        Enumeration requirements = command.getRequirements();
        while (requirements.hasMoreElements()) {
            ((Subsystem)requirements.nextElement()).setCurrentCommand(null);
        }
        command.removed();
    }

    public void removeAll() {
        while (this.firstCommand != null) {
            this.remove(this.firstCommand.getData());
        }
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public String getName() {
        return "Scheduler";
    }

    public String getType() {
        return "Scheduler";
    }

    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.commands = new StringArray();
        this.ids = new NumberArray();
        this.toCancel = new NumberArray();
        this.m_table.putValue("Names", (Object)this.commands);
        this.m_table.putValue("Ids", (Object)this.ids);
        this.m_table.putValue("Cancel", (Object)this.toCancel);
    }

    private void updateTable() {
        if (this.m_table != null) {
            LinkedListElement e;
            this.m_table.retrieveValue("Cancel", (Object)this.toCancel);
            if (this.toCancel.size() > 0) {
                for (e = this.firstCommand; e != null; e = e.getNext()) {
                    for (int i = 0; i < this.toCancel.size(); ++i) {
                        if ((double)e.getData().hashCode() != this.toCancel.get(i)) continue;
                        e.getData().cancel();
                    }
                }
                this.toCancel.setSize(0);
                this.m_table.putValue("Cancel", (Object)this.toCancel);
            }
            if (this.m_runningCommandsChanged) {
                this.commands.setSize(0);
                this.ids.setSize(0);
                for (e = this.firstCommand; e != null; e = e.getNext()) {
                    this.commands.add(e.getData().getName());
                    this.ids.add((double)e.getData().hashCode());
                }
                this.m_table.putValue("Names", (Object)this.commands);
                this.m_table.putValue("Ids", (Object)this.ids);
            }
        }
    }

    public ITable getTable() {
        return this.m_table;
    }

    public String getSmartDashboardType() {
        return "Scheduler";
    }
}

