/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Subsystem
implements NamedSendable {
    private boolean initializedDefaultCommand = false;
    private Command currentCommand;
    private boolean currentCommandChanged;
    private Command defaultCommand;
    private String name;
    private static Vector allSubsystems = new Vector();
    private ITable table;

    public Subsystem(String name) {
        this.name = name;
        Scheduler.getInstance().registerSubsystem(this);
    }

    public Subsystem() {
        this.name = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        Scheduler.getInstance().registerSubsystem(this);
        this.currentCommandChanged = true;
    }

    protected abstract void initDefaultCommand();

    protected void setDefaultCommand(Command command) {
        if (command == null) {
            this.defaultCommand = null;
        } else {
            boolean found = false;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                if (!requirements.nextElement().equals(this)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalUseOfCommandException("A default command must require the subsystem");
            }
            this.defaultCommand = command;
        }
        if (this.table != null) {
            if (this.defaultCommand != null) {
                this.table.putBoolean("hasDefault", true);
                this.table.putString("default", this.defaultCommand.getName());
            } else {
                this.table.putBoolean("hasDefault", false);
            }
        }
    }

    protected Command getDefaultCommand() {
        if (!this.initializedDefaultCommand) {
            this.initializedDefaultCommand = true;
            this.initDefaultCommand();
        }
        return this.defaultCommand;
    }

    void setCurrentCommand(Command command) {
        this.currentCommand = command;
        this.currentCommandChanged = true;
    }

    void confirmCommand() {
        if (this.currentCommandChanged) {
            if (this.table != null) {
                if (this.currentCommand != null) {
                    this.table.putBoolean("hasCommand", true);
                    this.table.putString("command", this.currentCommand.getName());
                } else {
                    this.table.putBoolean("hasCommand", false);
                }
            }
            this.currentCommandChanged = false;
        }
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getSmartDashboardType() {
        return "Subsystem";
    }

    public void initTable(ITable table) {
        this.table = table;
        if (table != null) {
            if (this.defaultCommand != null) {
                table.putBoolean("hasDefault", true);
                table.putString("default", this.defaultCommand.getName());
            } else {
                table.putBoolean("hasDefault", false);
            }
            if (this.currentCommand != null) {
                table.putBoolean("hasCommand", true);
                table.putString("command", this.currentCommand.getName());
            } else {
                table.putBoolean("hasCommand", false);
            }
        }
    }

    public ITable getTable() {
        return this.table;
    }
}

