/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.communication;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import com.sun.cldc.jna.TaskExecutor;
import edu.wpi.first.wpilibj.communication.FRCCommonControlData;
import edu.wpi.first.wpilibj.communication.Semaphore;

public final class FRCControl {
    private static final TaskExecutor taskExecutor = new TaskExecutor("FRCControl Task executor");
    private static final BlockingFunction getCommonControlDataFn = NativeLibrary.getDefaultInstance().getBlockingFunction("getCommonControlData");
    private static final BlockingFunction getDynamicControlDataFn = NativeLibrary.getDefaultInstance().getBlockingFunction("getDynamicControlData");
    private static final BlockingFunction setStatusDataFn = NativeLibrary.getDefaultInstance().getBlockingFunction("setStatusDataFloatAsInt");
    private static final BlockingFunction setErrorDataFn = NativeLibrary.getDefaultInstance().getBlockingFunction("setErrorData");
    private static final BlockingFunction setUserDsLcdDataFn = NativeLibrary.getDefaultInstance().getBlockingFunction("setUserDsLcdData");
    private static final BlockingFunction overrideIOConfigFn = NativeLibrary.getDefaultInstance().getBlockingFunction("overrideIOConfig");
    private static final BlockingFunction setNewDataSemFn = NativeLibrary.getDefaultInstance().getBlockingFunction("setNewDataSem");
    private static final Function observeUserProgramStartingFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_observeUserProgramStarting");
    private static final Function observeUserProgramDisabledFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_observeUserProgramDisabled");
    private static final Function observeUserProgramAutonomousFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_observeUserProgramAutonomous");
    private static final Function observeUserProgramTeleopFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_observeUserProgramTeleop");
    private static final Function observeUserProgramTestFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_observeUserProgramTest");
    public static final int IO_CONFIG_DATA_SIZE = 32;
    public static final int USER_CONTROL_DATA_SIZE = 904;
    public static final int USER_STATUS_DATA_SIZE = 984;
    public static final int USER_DS_LCD_DATA_SIZE = 128;
    private static final CachedNativeBuffer controlDataCache;
    private static final CachedNativeBuffer statusDataCacheHigh;
    private static final CachedNativeBuffer statusDataCacheLow;
    private static final CachedNativeBuffer ioConfigDataCache;

    private FRCControl() {
    }

    public static int getCommonControlData(FRCCommonControlData data, int wait_ms) {
        int res = getCommonControlDataFn.call2(data.getPointer(), wait_ms);
        if (res == 0) {
            data.read();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDynamicControlData(byte type, DynamicControlData dynamicData, int maxLength, int wait_ms) {
        CachedNativeBuffer cachedNativeBuffer = controlDataCache;
        synchronized (cachedNativeBuffer) {
            dynamicData.write();
            int res = getDynamicControlDataFn.call4((int)type, dynamicData.getPointer(), maxLength, wait_ms);
            if (res == 0) {
                dynamicData.read();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int overrideIOConfig(DynamicControlData ioConfig, int wait_ms) {
        CachedNativeBuffer cachedNativeBuffer = ioConfigDataCache;
        synchronized (cachedNativeBuffer) {
            ioConfig.write();
            int res = overrideIOConfigFn.call2(ioConfig.getPointer(), wait_ms);
            if (res == 0) {
                ioConfig.read();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setStatusData(double battery, int dsDigitalOut, int updateNumber, byte[] userDataHigh, int userDataHighLength, byte[] userDataLow, int userDataLowLength, int wait_ms) {
        CachedNativeBuffer cachedNativeBuffer = statusDataCacheHigh;
        synchronized (cachedNativeBuffer) {
            Pointer userDataPtrHigh = statusDataCacheHigh.getBufferSized(userDataHighLength);
            userDataPtrHigh.setBytes(0L, userDataHigh, 0, userDataHighLength);
            Pointer userDataPtrLow = statusDataCacheLow.getBufferSized(userDataLowLength);
            userDataPtrLow.setBytes(0L, userDataLow, 0, userDataLowLength);
            int res = setStatusDataFn.call8(Float.floatToIntBits((float)battery), dsDigitalOut, updateNumber, userDataPtrHigh.address().toUWord().toPrimitive(), userDataHighLength, userDataPtrLow.address().toUWord().toPrimitive(), userDataLowLength, wait_ms);
            return res;
        }
    }

    public static void setErrorData(byte[] bytes, int length, int timeOut) {
        Pointer textPtr = new Pointer(bytes.length);
        textPtr.setBytes(0L, bytes, 0, bytes.length);
        setErrorDataFn.call3(textPtr, length, timeOut);
        textPtr.free();
    }

    public static void setErrorData(Pointer textPtr, int length, int timeOut) {
        if (length > textPtr.getSize()) {
            throw new IllegalArgumentException();
        }
        setErrorDataFn.call3(textPtr, length, timeOut);
    }

    public static void setUserDsLcdData(byte[] bytes, int length, int timeOut) {
        Pointer textPtr = new Pointer(bytes.length);
        textPtr.setBytes(0L, bytes, 0, bytes.length);
        setUserDsLcdDataFn.call3(textPtr, length, timeOut);
        textPtr.free();
    }

    public static void setNewDataSem(Semaphore sem) {
        if (sem == null || sem.m_semaphore == null) {
            throw new NullPointerException("Null provided for a semaphore");
        }
        setNewDataSemFn.call1(sem.m_semaphore);
    }

    public static void observeUserProgramStarting() {
        observeUserProgramStartingFn.call0();
    }

    public static void observeUserProgramDisabled() {
        observeUserProgramDisabledFn.call0();
    }

    public static void observeUserProgramAutonomous() {
        observeUserProgramAutonomousFn.call0();
    }

    public static void observeUserProgramTeleop() {
        observeUserProgramTeleopFn.call0();
    }

    public static void observeUserProgramTest() {
        observeUserProgramTestFn.call0();
    }

    static {
        getCommonControlDataFn.setTaskExecutor(taskExecutor);
        getDynamicControlDataFn.setTaskExecutor(taskExecutor);
        setStatusDataFn.setTaskExecutor(taskExecutor);
        setErrorDataFn.setTaskExecutor(taskExecutor);
        setUserDsLcdDataFn.setTaskExecutor(taskExecutor);
        setNewDataSemFn.setTaskExecutor(taskExecutor);
        overrideIOConfigFn.setTaskExecutor(taskExecutor);
        controlDataCache = new CachedNativeBuffer();
        statusDataCacheHigh = new CachedNativeBuffer();
        statusDataCacheLow = new CachedNativeBuffer();
        ioConfigDataCache = new CachedNativeBuffer();
    }

    public static abstract class DynamicControlData
    extends Structure {
    }

    public static class CachedNativeBuffer {
        private Pointer buffer;

        public Pointer getBufferSized(int size) {
            if (this.buffer == null) {
                this.buffer = new Pointer(size);
            }
            if (size > this.buffer.getSize()) {
                this.buffer.free();
                this.buffer = new Pointer(size);
            }
            return this.buffer;
        }

        public void free() {
            if (this.buffer != null) {
                this.buffer.free();
                this.buffer = null;
            }
        }
    }
}

