/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.communication;

public class SemaphoreException
extends Exception {
    public static final int M_semLib = 0x160000;
    public static final int M_objLib = 0x3D0000;
    public static final int S_objLib_OBJ_ID_ERROR = 3997697;
    public static final int S_objLib_OBJ_UNAVAILABLE = 3997698;
    public static final int S_objLib_OBJ_DELETED = 0x3D0003;
    public static final int S_objLib_OBJ_TIMEOUT = 3997700;
    public static final int S_semLib_INVALID_STATE = 1441893;
    public static final int S_semLib_INVALID_OPTION = 0x160066;
    public static final int S_semLib_INVALID_QUEUE_TYPE = 1441895;
    public static final int S_semLib_INVALID_OPERATION = 1441896;
    public static final int S_semLib_INVALID_INITIAL_COUNT = 1441897;
    public static final int S_semLib_COUNT_OVERFLOW = 1441898;

    public SemaphoreException(int status) {
        super(SemaphoreException.lookUpCode(status));
    }

    private static String lookUpCode(int status) {
        switch (status) {
            case 3997697: {
                return "OBJ_ID_ERROR";
            }
            case 3997698: {
                return "OBJ_UNAVAILABLE";
            }
            case 0x3D0003: {
                return "OBJ_DELETED";
            }
            case 3997700: {
                return "OBJ_TIMEOUT";
            }
            case 1441893: {
                return "Invalid semaphore state";
            }
            case 0x160066: {
                return "Invalid semaphore option";
            }
            case 1441895: {
                return "Invalid semaphore queue type";
            }
            case 1441896: {
                return "Invalid semaphore operation";
            }
            case 1441897: {
                return "Invalid semaphore initial count";
            }
            case 1441898: {
                return "Semaphore count overflow";
            }
        }
        return "Unrecognized status code";
    }
}

