/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiFpga;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tCounter
extends tSystem {
    public static final int kNumSystems = 8;
    public final int m_SystemIndex;
    private static final int kOutput_Direction_BitfieldMask = Integer.MIN_VALUE;
    private static final int kOutput_Direction_BitfieldOffset = 31;
    private static final int kOutput_Value_BitfieldMask = Integer.MAX_VALUE;
    private static final int kOutput_Value_BitfieldOffset = 0;
    private static final int kCounter0_Output_Address = 33512;
    private static final int kCounter1_Output_Address = 33532;
    private static final int kCounter2_Output_Address = 33552;
    private static final int kCounter3_Output_Address = 33572;
    private static final int kCounter4_Output_Address = 33592;
    private static final int kCounter5_Output_Address = 33612;
    private static final int kCounter6_Output_Address = 33632;
    private static final int kCounter7_Output_Address = 33652;
    private static final int[] kOutput_Addresses = new int[]{33512, 33532, 33552, 33572, 33592, 33612, 33632, 33652};
    private static final int kConfig_UpSource_Channel_BitfieldMask = -268435456;
    private static final int kConfig_UpSource_Channel_BitfieldOffset = 28;
    private static final int kConfig_UpSource_Module_BitfieldMask = 0x8000000;
    private static final int kConfig_UpSource_Module_BitfieldOffset = 27;
    private static final int kConfig_UpSource_AnalogTrigger_BitfieldMask = 0x4000000;
    private static final int kConfig_UpSource_AnalogTrigger_BitfieldOffset = 26;
    private static final int kConfig_DownSource_Channel_BitfieldMask = 0x3C00000;
    private static final int kConfig_DownSource_Channel_BitfieldOffset = 22;
    private static final int kConfig_DownSource_Module_BitfieldMask = 0x200000;
    private static final int kConfig_DownSource_Module_BitfieldOffset = 21;
    private static final int kConfig_DownSource_AnalogTrigger_BitfieldMask = 0x100000;
    private static final int kConfig_DownSource_AnalogTrigger_BitfieldOffset = 20;
    private static final int kConfig_IndexSource_Channel_BitfieldMask = 983040;
    private static final int kConfig_IndexSource_Channel_BitfieldOffset = 16;
    private static final int kConfig_IndexSource_Module_BitfieldMask = 32768;
    private static final int kConfig_IndexSource_Module_BitfieldOffset = 15;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldMask = 16384;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldOffset = 14;
    private static final int kConfig_IndexActiveHigh_BitfieldMask = 8192;
    private static final int kConfig_IndexActiveHigh_BitfieldOffset = 13;
    private static final int kConfig_UpRisingEdge_BitfieldMask = 4096;
    private static final int kConfig_UpRisingEdge_BitfieldOffset = 12;
    private static final int kConfig_UpFallingEdge_BitfieldMask = 2048;
    private static final int kConfig_UpFallingEdge_BitfieldOffset = 11;
    private static final int kConfig_DownRisingEdge_BitfieldMask = 1024;
    private static final int kConfig_DownRisingEdge_BitfieldOffset = 10;
    private static final int kConfig_DownFallingEdge_BitfieldMask = 512;
    private static final int kConfig_DownFallingEdge_BitfieldOffset = 9;
    private static final int kConfig_Mode_BitfieldMask = 384;
    private static final int kConfig_Mode_BitfieldOffset = 7;
    private static final int kConfig_PulseLengthThreshold_BitfieldMask = 126;
    private static final int kConfig_PulseLengthThreshold_BitfieldOffset = 1;
    private static final int kConfig_PulseLengthThreshold_FixedPointIntegerShift = 8;
    private static final int kConfig_Enable_BitfieldMask = 1;
    private static final int kConfig_Enable_BitfieldOffset = 0;
    private static final int kCounter0_Config_Address = 33504;
    private static final int kCounter1_Config_Address = 33524;
    private static final int kCounter2_Config_Address = 33544;
    private static final int kCounter3_Config_Address = 33564;
    private static final int kCounter4_Config_Address = 33584;
    private static final int kCounter5_Config_Address = 33604;
    private static final int kCounter6_Config_Address = 33624;
    private static final int kCounter7_Config_Address = 33644;
    private static final int[] kConfig_Addresses = new int[]{33504, 33524, 33544, 33564, 33584, 33604, 33624, 33644};
    private static final int kTimerOutput_Period_BitfieldMask = -512;
    private static final int kTimerOutput_Period_BitfieldOffset = 9;
    private static final int kTimerOutput_Period_FixedPointIntegerShift = 1;
    private static final int kTimerOutput_Count_BitfieldMask = 510;
    private static final int kTimerOutput_Count_BitfieldOffset = 1;
    private static final int kTimerOutput_Stalled_BitfieldMask = 1;
    private static final int kTimerOutput_Stalled_BitfieldOffset = 0;
    private static final int kCounter0_TimerOutput_Address = 33520;
    private static final int kCounter1_TimerOutput_Address = 33540;
    private static final int kCounter2_TimerOutput_Address = 33560;
    private static final int kCounter3_TimerOutput_Address = 33580;
    private static final int kCounter4_TimerOutput_Address = 33600;
    private static final int kCounter5_TimerOutput_Address = 33620;
    private static final int kCounter6_TimerOutput_Address = 33640;
    private static final int kCounter7_TimerOutput_Address = 33660;
    private static final int[] kTimerOutput_Addresses = new int[]{33520, 33540, 33560, 33580, 33600, 33620, 33640, 33660};
    private static final int kCounter0_Reset_Address = 33508;
    private static final int kCounter1_Reset_Address = 33528;
    private static final int kCounter2_Reset_Address = 33548;
    private static final int kCounter3_Reset_Address = 33568;
    private static final int kCounter4_Reset_Address = 33588;
    private static final int kCounter5_Reset_Address = 33608;
    private static final int kCounter6_Reset_Address = 33628;
    private static final int kCounter7_Reset_Address = 33648;
    private static final int[] kReset_Addresses = new int[]{33508, 33528, 33548, 33568, 33588, 33608, 33628, 33648};
    private static final int kTimerConfig_StallPeriod_BitfieldMask = -256;
    private static final int kTimerConfig_StallPeriod_BitfieldOffset = 8;
    private static final int kTimerConfig_StallPeriod_FixedPointIntegerShift = 1;
    private static final int kTimerConfig_AverageSize_BitfieldMask = 254;
    private static final int kTimerConfig_AverageSize_BitfieldOffset = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldMask = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldOffset = 0;
    private static final int kCounter0_TimerConfig_Address = 33516;
    private static final int kCounter1_TimerConfig_Address = 33536;
    private static final int kCounter2_TimerConfig_Address = 33556;
    private static final int kCounter3_TimerConfig_Address = 33576;
    private static final int kCounter4_TimerConfig_Address = 33596;
    private static final int kCounter5_TimerConfig_Address = 33616;
    private static final int kCounter6_TimerConfig_Address = 33636;
    private static final int kCounter7_TimerConfig_Address = 33656;
    private static final int[] kTimerConfig_Addresses = new int[]{33516, 33536, 33556, 33576, 33596, 33616, 33636, 33656};

    public tCounter(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 8) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public int readOutput() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public boolean readOutput_Direction() {
        int result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & Integer.MIN_VALUE) >>> 31;
        return bitfieldValue != 0;
    }

    public int readOutput_Value() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & Integer.MAX_VALUE) >>> 0;
        bitfieldValue <<= 1;
        return bitfieldValue >>= 1;
    }

    public void writeConfig(int value) {
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeConfig_UpSource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 28 & 0xF0000000, status);
    }

    public void writeConfig_UpSource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xF7FFFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 27 & 0x8000000, status);
    }

    public void writeConfig_UpSource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFBFFFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 26 & 0x4000000, status);
    }

    public void writeConfig_DownSource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFC3FFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 22 & 0x3C00000, status);
    }

    public void writeConfig_DownSource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFDFFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 21 & 0x200000, status);
    }

    public void writeConfig_DownSource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFEFFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 20 & 0x100000, status);
    }

    public void writeConfig_IndexSource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF0FFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 16 & 0xF0000, status);
    }

    public void writeConfig_IndexSource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF7FFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 15 & 0x8000, status);
    }

    public void writeConfig_IndexSource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFBFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 14 & 0x4000, status);
    }

    public void writeConfig_IndexActiveHigh(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFDFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 13 & 0x2000, status);
    }

    public void writeConfig_UpRisingEdge(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFEFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 12 & 0x1000, status);
    }

    public void writeConfig_UpFallingEdge(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF7FF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 11 & 0x800, status);
    }

    public void writeConfig_DownRisingEdge(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFBFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 10 & 0x400, status);
    }

    public void writeConfig_DownFallingEdge(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFDFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 9 & 0x200, status);
    }

    public void writeConfig_Mode(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFE7F;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 7 & 0x180, status);
    }

    public void writeConfig_PulseLengthThreshold(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF81;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value >>> 8 << 1 & 0x7E, status);
    }

    public void writeConfig_Enable(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readConfig() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readConfig_UpSource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0000000) >>> 28;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_UpSource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x8000000) >>> 27;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_UpSource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x4000000) >>> 26;
        return bitfieldValue != 0;
    }

    public byte readConfig_DownSource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x3C00000) >>> 22;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_DownSource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x200000) >>> 21;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_DownSource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x100000) >>> 20;
        return bitfieldValue != 0;
    }

    public byte readConfig_IndexSource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0000) >>> 16;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_IndexSource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x8000) >>> 15;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_IndexSource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x4000) >>> 14;
        return bitfieldValue != 0;
    }

    public boolean readConfig_IndexActiveHigh() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x2000) >>> 13;
        return bitfieldValue != 0;
    }

    public boolean readConfig_UpRisingEdge() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x1000) >>> 12;
        return bitfieldValue != 0;
    }

    public boolean readConfig_UpFallingEdge() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x800) >>> 11;
        return bitfieldValue != 0;
    }

    public boolean readConfig_DownRisingEdge() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x400) >>> 10;
        return bitfieldValue != 0;
    }

    public boolean readConfig_DownFallingEdge() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x200) >>> 9;
        return bitfieldValue != 0;
    }

    public byte readConfig_Mode() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x180) >>> 7;
        return (byte)(bitfieldValue & 3);
    }

    public short readConfig_PulseLengthThreshold() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x7E) >>> 1 << 8;
        return (short)(bitfieldValue & 0x3FFF);
    }

    public boolean readConfig_Enable() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public int readTimerOutput() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerOutput_Period() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFE00) >>> 9 << 1;
        return bitfieldValue & 0xFFFFFF;
    }

    public byte readTimerOutput_Count() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1FE) >>> 1;
        bitfieldValue <<= 24;
        return (byte)(bitfieldValue >>= 24);
    }

    public boolean readTimerOutput_Stalled() {
        int result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public void strobeReset() {
        NiFpga.writeU32(m_DeviceHandle, kReset_Addresses[this.m_SystemIndex], 1, status);
    }

    public void writeTimerConfig(int value) {
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeTimerConfig_StallPeriod(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFF;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value >>> 1 << 8 & 0xFFFFFF00, status);
    }

    public void writeTimerConfig_AverageSize(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF01;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value << 1 & 0xFE, status);
    }

    public void writeTimerConfig_UpdateWhenEmpty(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readTimerConfig() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerConfig_StallPeriod() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFF00) >>> 8 << 1;
        return bitfieldValue & 0x1FFFFFF;
    }

    public byte readTimerConfig_AverageSize() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFE) >>> 1;
        return (byte)(bitfieldValue & 0x7F);
    }

    public boolean readTimerConfig_UpdateWhenEmpty() {
        int result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }
}

