/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiFpga;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tEncoder
extends tSystem {
    public static final int kNumSystems = 4;
    public final int m_SystemIndex;
    private static final int kOutput_Direction_BitfieldMask = Integer.MIN_VALUE;
    private static final int kOutput_Direction_BitfieldOffset = 31;
    private static final int kOutput_Value_BitfieldMask = Integer.MAX_VALUE;
    private static final int kOutput_Value_BitfieldOffset = 0;
    private static final int kEncoder0_Output_Address = 33672;
    private static final int kEncoder1_Output_Address = 33692;
    private static final int kEncoder2_Output_Address = 33712;
    private static final int kEncoder3_Output_Address = 33732;
    private static final int[] kOutput_Addresses = new int[]{33672, 33692, 33712, 33732};
    private static final int kConfig_ASource_Channel_BitfieldMask = 0x1E0000;
    private static final int kConfig_ASource_Channel_BitfieldOffset = 17;
    private static final int kConfig_ASource_Module_BitfieldMask = 65536;
    private static final int kConfig_ASource_Module_BitfieldOffset = 16;
    private static final int kConfig_ASource_AnalogTrigger_BitfieldMask = 32768;
    private static final int kConfig_ASource_AnalogTrigger_BitfieldOffset = 15;
    private static final int kConfig_BSource_Channel_BitfieldMask = 30720;
    private static final int kConfig_BSource_Channel_BitfieldOffset = 11;
    private static final int kConfig_BSource_Module_BitfieldMask = 1024;
    private static final int kConfig_BSource_Module_BitfieldOffset = 10;
    private static final int kConfig_BSource_AnalogTrigger_BitfieldMask = 512;
    private static final int kConfig_BSource_AnalogTrigger_BitfieldOffset = 9;
    private static final int kConfig_IndexSource_Channel_BitfieldMask = 480;
    private static final int kConfig_IndexSource_Channel_BitfieldOffset = 5;
    private static final int kConfig_IndexSource_Module_BitfieldMask = 16;
    private static final int kConfig_IndexSource_Module_BitfieldOffset = 4;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldMask = 8;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldOffset = 3;
    private static final int kConfig_IndexActiveHigh_BitfieldMask = 4;
    private static final int kConfig_IndexActiveHigh_BitfieldOffset = 2;
    private static final int kConfig_Reverse_BitfieldMask = 2;
    private static final int kConfig_Reverse_BitfieldOffset = 1;
    private static final int kConfig_Enable_BitfieldMask = 1;
    private static final int kConfig_Enable_BitfieldOffset = 0;
    private static final int kEncoder0_Config_Address = 33664;
    private static final int kEncoder1_Config_Address = 33684;
    private static final int kEncoder2_Config_Address = 33704;
    private static final int kEncoder3_Config_Address = 33724;
    private static final int[] kConfig_Addresses = new int[]{33664, 33684, 33704, 33724};
    private static final int kTimerOutput_Period_BitfieldMask = -512;
    private static final int kTimerOutput_Period_BitfieldOffset = 9;
    private static final int kTimerOutput_Period_FixedPointIntegerShift = 1;
    private static final int kTimerOutput_Count_BitfieldMask = 510;
    private static final int kTimerOutput_Count_BitfieldOffset = 1;
    private static final int kTimerOutput_Stalled_BitfieldMask = 1;
    private static final int kTimerOutput_Stalled_BitfieldOffset = 0;
    private static final int kEncoder0_TimerOutput_Address = 33680;
    private static final int kEncoder1_TimerOutput_Address = 33700;
    private static final int kEncoder2_TimerOutput_Address = 33720;
    private static final int kEncoder3_TimerOutput_Address = 33740;
    private static final int[] kTimerOutput_Addresses = new int[]{33680, 33700, 33720, 33740};
    private static final int kEncoder0_Reset_Address = 33668;
    private static final int kEncoder1_Reset_Address = 33688;
    private static final int kEncoder2_Reset_Address = 33708;
    private static final int kEncoder3_Reset_Address = 33728;
    private static final int[] kReset_Addresses = new int[]{33668, 33688, 33708, 33728};
    private static final int kTimerConfig_StallPeriod_BitfieldMask = -256;
    private static final int kTimerConfig_StallPeriod_BitfieldOffset = 8;
    private static final int kTimerConfig_StallPeriod_FixedPointIntegerShift = 1;
    private static final int kTimerConfig_AverageSize_BitfieldMask = 254;
    private static final int kTimerConfig_AverageSize_BitfieldOffset = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldMask = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldOffset = 0;
    private static final int kEncoder0_TimerConfig_Address = 33676;
    private static final int kEncoder1_TimerConfig_Address = 33696;
    private static final int kEncoder2_TimerConfig_Address = 33716;
    private static final int kEncoder3_TimerConfig_Address = 33736;
    private static final int[] kTimerConfig_Addresses = new int[]{33676, 33696, 33716, 33736};

    public tEncoder(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 4) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public int readOutput() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public boolean readOutput_Direction() {
        int result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & Integer.MIN_VALUE) >>> 31;
        return bitfieldValue != 0;
    }

    public int readOutput_Value() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & Integer.MAX_VALUE) >>> 0;
        bitfieldValue <<= 1;
        return bitfieldValue >>= 1;
    }

    public void writeConfig(int value) {
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeConfig_ASource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFE1FFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 17 & 0x1E0000, status);
    }

    public void writeConfig_ASource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFEFFFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 16 & 0x10000, status);
    }

    public void writeConfig_ASource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF7FFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 15 & 0x8000, status);
    }

    public void writeConfig_BSource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF87FF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 11 & 0x7800, status);
    }

    public void writeConfig_BSource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFBFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 10 & 0x400, status);
    }

    public void writeConfig_BSource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFDFF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 9 & 0x200, status);
    }

    public void writeConfig_IndexSource_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFE1F;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 5 & 0x1E0, status);
    }

    public void writeConfig_IndexSource_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFEF;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 4 & 0x10, status);
    }

    public void writeConfig_IndexSource_AnalogTrigger(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF7;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 3 & 8, status);
    }

    public void writeConfig_IndexActiveHigh(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFB;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 2 & 4, status);
    }

    public void writeConfig_Reverse(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFD;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 1 & 2, status);
    }

    public void writeConfig_Enable(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiFpga.writeU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readConfig() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readConfig_ASource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1E0000) >>> 17;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_ASource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x10000) >>> 16;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_ASource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x8000) >>> 15;
        return bitfieldValue != 0;
    }

    public byte readConfig_BSource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x7800) >>> 11;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_BSource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x400) >>> 10;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_BSource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x200) >>> 9;
        return bitfieldValue != 0;
    }

    public byte readConfig_IndexSource_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1E0) >>> 5;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_IndexSource_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x10) >>> 4;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_IndexSource_AnalogTrigger() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 8) >>> 3;
        return bitfieldValue != 0;
    }

    public boolean readConfig_IndexActiveHigh() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 4) >>> 2;
        return bitfieldValue != 0;
    }

    public boolean readConfig_Reverse() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 2) >>> 1;
        return bitfieldValue != 0;
    }

    public boolean readConfig_Enable() {
        int result = NiFpga.readU32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public int readTimerOutput() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerOutput_Period() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFE00) >>> 9 << 1;
        return bitfieldValue & 0xFFFFFF;
    }

    public byte readTimerOutput_Count() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1FE) >>> 1;
        bitfieldValue <<= 24;
        return (byte)(bitfieldValue >>= 24);
    }

    public boolean readTimerOutput_Stalled() {
        int result = NiFpga.readU32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public void strobeReset() {
        NiFpga.writeU32(m_DeviceHandle, kReset_Addresses[this.m_SystemIndex], 1, status);
    }

    public void writeTimerConfig(int value) {
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeTimerConfig_StallPeriod(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFF;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value >>> 1 << 8 & 0xFFFFFF00, status);
    }

    public void writeTimerConfig_AverageSize(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF01;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value << 1 & 0xFE, status);
    }

    public void writeTimerConfig_UpdateWhenEmpty(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiFpga.writeU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readTimerConfig() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerConfig_StallPeriod() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFF00) >>> 8 << 1;
        return bitfieldValue & 0x1FFFFFF;
    }

    public byte readTimerConfig_AverageSize() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFE) >>> 1;
        return (byte)(bitfieldValue & 0x7F);
    }

    public boolean readTimerConfig_UpdateWhenEmpty() {
        int result = NiFpga.readU32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }
}

