/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;

public class LinearAverages {
    Pointer columnAveragesPtr;
    int columnCount;
    float[] columnAverages;
    Pointer rowAveragesPtr;
    int rowCount;
    float[] rowAverages;
    Pointer risingDiagAveragesPtr;
    int risingDiagCount;
    float[] risingDiagAverages;
    Pointer fallingDiagAveragesPtr;
    int fallingDiagCount;
    float[] fallingDiagAverages;

    LinearAverages(int address) {
        new LinearAveragesStruct(address);
    }

    public float[] getColumnAverages() {
        return this.columnAverages;
    }

    public float[] getRowAverages() {
        return this.rowAverages;
    }

    public float[] getRisingDiagAverages() {
        return this.risingDiagAverages;
    }

    public float[] getFallingDiagAverages() {
        return this.fallingDiagAverages;
    }

    private class LinearAveragesStruct
    extends Structure {
        public void read() {
            LinearAverages.this.columnCount = this.backingNativeMemory.getInt(4L);
            LinearAverages.this.columnAveragesPtr = this.backingNativeMemory.getPointer(0, 4 * LinearAverages.this.columnCount);
            LinearAverages.this.columnAverages = new float[LinearAverages.this.columnCount];
            LinearAverages.this.columnAveragesPtr.getFloats(0L, LinearAverages.this.columnAverages, 0, LinearAverages.this.columnCount);
            LinearAverages.this.rowCount = this.backingNativeMemory.getInt(12L);
            LinearAverages.this.rowAveragesPtr = this.backingNativeMemory.getPointer(8, 4 * LinearAverages.this.rowCount);
            LinearAverages.this.rowAverages = new float[LinearAverages.this.rowCount];
            LinearAverages.this.rowAveragesPtr.getFloats(0L, LinearAverages.this.rowAverages, 0, LinearAverages.this.rowCount);
            LinearAverages.this.risingDiagCount = this.backingNativeMemory.getInt(20L);
            LinearAverages.this.risingDiagAveragesPtr = this.backingNativeMemory.getPointer(16, 4 * LinearAverages.this.risingDiagCount);
            LinearAverages.this.risingDiagAverages = new float[LinearAverages.this.risingDiagCount];
            LinearAverages.this.risingDiagAveragesPtr.getFloats(0L, LinearAverages.this.risingDiagAverages, 0, LinearAverages.this.risingDiagCount);
            LinearAverages.this.fallingDiagCount = this.backingNativeMemory.getInt(28L);
            LinearAverages.this.fallingDiagAveragesPtr = this.backingNativeMemory.getPointer(24, 4 * LinearAverages.this.fallingDiagCount);
            LinearAverages.this.fallingDiagAverages = new float[LinearAverages.this.fallingDiagCount];
            LinearAverages.this.fallingDiagAveragesPtr.getFloats(0L, LinearAverages.this.fallingDiagAverages, 0, LinearAverages.this.fallingDiagCount);
        }

        public void write() {
            this.backingNativeMemory.setPointer(0, LinearAverages.this.columnAveragesPtr);
            this.backingNativeMemory.setInt(4L, LinearAverages.this.columnCount);
            this.backingNativeMemory.setPointer(8, LinearAverages.this.rowAveragesPtr);
            this.backingNativeMemory.setInt(12L, LinearAverages.this.rowCount);
            this.backingNativeMemory.setPointer(16, LinearAverages.this.risingDiagAveragesPtr);
            this.backingNativeMemory.setInt(20L, LinearAverages.this.risingDiagCount);
            this.backingNativeMemory.setPointer(24, LinearAverages.this.fallingDiagAveragesPtr);
            this.backingNativeMemory.setInt(28L, LinearAverages.this.fallingDiagCount);
        }

        public int size() {
            return 32;
        }

        public void free() {
            this.release();
        }

        public LinearAveragesStruct(int address) {
            this.useMemory(new Pointer((long)address, this.size()));
            this.read();
        }
    }

    public static class LinearAveragesMode {
        public final int value;
        static final int IMAQ_COLUMN_AVERAGES_val = 1;
        static final int IMAQ_ROW_AVERAGES_val = 2;
        static final int IMAQ_RISING_DIAG_AVERAGES_val = 4;
        static final int IMAQ_FALLING_DIAG_AVERAGES_val = 8;
        static final int IMAQ_ALL_LINEAR_AVERAGES_val = 15;
        public static final LinearAveragesMode IMAQ_COLUMN_AVERAGES = new LinearAveragesMode(1);
        public static final LinearAveragesMode IMAQ_ROW_AVERAGES = new LinearAveragesMode(2);
        public static final LinearAveragesMode IMAQ_RISING_DIAG_AVERAGES = new LinearAveragesMode(4);
        public static final LinearAveragesMode IMAQ_FALLING_DIAG_AVERAGES = new LinearAveragesMode(8);
        public static final LinearAveragesMode IMAQ_ALL_LINEAR_AVERAGES = new LinearAveragesMode(15);

        private LinearAveragesMode(int value) {
            this.value = value;
        }
    }
}

