/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.sun.cldc.jna.Structure;

public class ShapeDetectionOptions
extends Structure {
    int mode;
    int angleRanges;
    int numAngleRanges;
    float scaleRangeMin;
    float scaleRangeMax;
    double minMatchScore;
    public static final int IMAQ_GEOMETRIC_MATCH_SHIFT_INVARIANT = 0;
    public static final int IMAQ_GEOMETRIC_MATCH_ROTATION_INVARIANT = 1;
    public static final int IMAQ_GEOMETRIC_MATCH_SCALE_INVARIANT = 2;
    public static final int IMAQ_GEOMETRIC_MATCH_OCCLUSION_INVARIANT = 4;

    public ShapeDetectionOptions(int mode, int angleRanges, int numAngleRanges, float scaleRangeMin, float scaleRangeMax, double minMatchScore) {
        this.mode = mode;
        this.angleRanges = angleRanges;
        this.numAngleRanges = numAngleRanges;
        this.scaleRangeMin = scaleRangeMin;
        this.scaleRangeMax = scaleRangeMax;
        this.minMatchScore = minMatchScore;
        this.allocateMemory();
        this.write();
    }

    public void read() {
        this.mode = this.backingNativeMemory.getInt(0L);
        this.angleRanges = this.backingNativeMemory.getInt(4L);
        this.numAngleRanges = this.backingNativeMemory.getInt(8L);
        this.scaleRangeMin = this.backingNativeMemory.getFloat(12L);
        this.scaleRangeMax = this.backingNativeMemory.getFloat(16L);
        this.minMatchScore = this.backingNativeMemory.getDouble(20L);
    }

    public void write() {
        this.backingNativeMemory.setInt(0L, this.mode);
        this.backingNativeMemory.setInt(4L, this.angleRanges);
        this.backingNativeMemory.setInt(8L, this.numAngleRanges);
        this.backingNativeMemory.setFloat(12L, this.scaleRangeMin);
        this.backingNativeMemory.setFloat(16L, this.scaleRangeMax);
        this.backingNativeMemory.setDouble(20L, this.minMatchScore);
    }

    public int size() {
        return 28;
    }

    public void free() {
        this.release();
    }
}

