/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.tables.ITable;

public class SendableChooser
implements Sendable {
    private static final String DEFAULT = "default";
    private static final String SELECTED = "selected";
    private static final String OPTIONS = "options";
    private StringArray choices = new StringArray();
    private List values = new List();
    private String defaultChoice = null;
    private Object defaultValue = null;
    private ITable table;

    public void addObject(String name, Object object) {
        if (this.defaultChoice == null) {
            this.addDefault(name, object);
            return;
        }
        for (int i = 0; i < this.choices.size(); ++i) {
            if (!this.choices.get(i).equals(name)) continue;
            this.choices.set(i, name);
            this.values.set(i, object);
            return;
        }
        this.choices.add(name);
        this.values.add(object);
        if (this.table != null) {
            this.table.putValue(OPTIONS, (Object)this.choices);
        }
    }

    public void addDefault(String name, Object object) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        this.defaultChoice = name;
        this.defaultValue = object;
        if (this.table != null) {
            this.table.putString(DEFAULT, this.defaultChoice);
        }
        this.addObject(name, object);
    }

    public Object getSelected() {
        String selected = this.table.getString(SELECTED, null);
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.choices.get(i).equals(selected)) continue;
            return this.values.get(i);
        }
        return this.defaultValue;
    }

    public String getSmartDashboardType() {
        return "String Chooser";
    }

    public void initTable(ITable table) {
        this.table = table;
        if (table != null) {
            table.putValue(OPTIONS, (Object)this.choices);
            if (this.defaultChoice != null) {
                table.putString(DEFAULT, this.defaultChoice);
            }
        }
    }

    public ITable getTable() {
        return this.table;
    }
}

