/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.visa;

import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.ptr.IntByReference;
import edu.wpi.first.wpilibj.visa.VisaException;

public class Visa {
    private static int status;
    private static final IntByReference pValue;
    public static final int VI_ATTR_ASRL_BAUD = 1073676321;
    public static final int VI_ATTR_ASRL_DATA_BITS = 1073676322;
    public static final int VI_ATTR_ASRL_PARITY = 1073676323;
    public static final int VI_ATTR_ASRL_STOP_BITS = 1073676324;
    public static final int VI_ATTR_ASRL_FLOW_CNTRL = 1073676325;
    public static final int VI_ATTR_TERMCHAR_EN = 1073676344;
    public static final int VI_ATTR_TERMCHAR = 1073676312;
    public static final int VI_ATTR_ASRL_END_IN = 1073676467;
    public static final int VI_ASRL_END_TERMCHAR = 2;
    public static final int VI_ASRL_END_NONE = 0;
    public static final int VI_ATTR_ASRL_AVAIL_NUM = 1073676460;
    public static final int VI_SUCCESS_TERM_CHAR = 1073676293;
    public static final int VI_SUCCESS_MAX_CNT = 1073676294;
    public static final int VI_ATTR_TMO_VALUE = 1073676314;
    public static final int VI_ATTR_WR_BUF_OPER_MODE = 1073676333;
    public static final short VI_READ_BUF = 1;
    public static final short VI_WRITE_BUF = 2;
    private static final Function viOpenDefaultRMFn;
    private static final Function viOpenFn;
    private static final Function viSetAttributeFn;
    private static final Function viSetBufFn;
    private static final Function viCloseFn;
    private static final Function viGetAttributeFn;
    private static final Function viVPrintfFn;
    private static final Function viBufReadFn;
    private static final Function viBufWriteFn;
    private static final Function viFlushFn;
    private static final Function viClearFn;

    public static synchronized int viOpenDefaultRM() throws VisaException {
        status = viOpenDefaultRMFn.call1(pValue.getPointer());
        Visa.assertCleanStatus("viOpenDefaultRM");
        return pValue.getValue();
    }

    public static synchronized int viOpen(int sesn, String name, int mode, int timeout) throws VisaException {
        Pointer pName = new Pointer(name.length());
        pName.setBytes(0L, name.getBytes(), 0, name.length());
        status = viOpenFn.call5(sesn, pName, mode, timeout, pValue.getPointer());
        Visa.assertCleanStatus("viOpen");
        pName.free();
        return pValue.getValue();
    }

    public static void viSetAttribute(int vi, int attrName, int attrValue) throws VisaException {
        status = viSetAttributeFn.call3(vi, attrName, attrValue);
        Visa.assertCleanStatus("viSetAttribute");
    }

    public static void viSetAttribute(int vi, int attrName, boolean attrValue) throws VisaException {
        status = viSetAttributeFn.call3(vi, attrName, attrValue ? 1 : 0);
        Visa.assertCleanStatus("viSetAttribute");
    }

    public static void viSetBuf(int vi, short buffer, int size) throws VisaException {
        status = viSetBufFn.call3(vi, (int)buffer, size);
        Visa.assertCleanStatus("viSetBuf");
    }

    public static void viClose(int vi) {
        viCloseFn.call1(vi);
    }

    public static synchronized int viGetAttribute(int vi, int attrName) throws VisaException {
        status = viGetAttributeFn.call3(vi, attrName, pValue.getPointer());
        Visa.assertCleanStatus("viGetAttribute");
        return pValue.getValue();
    }

    public static void viVPrintf(int vi, String write) throws VisaException {
        Pointer string = new Pointer(write.length());
        string.setBytes(0L, write.getBytes(), 0, write.length());
        status = viVPrintfFn.call2(vi, string);
        string.free();
        Visa.assertCleanStatus("viPrintf");
    }

    public static byte[] viBufRead(int vi, int cnt) throws VisaException {
        Pointer bytes = new Pointer(cnt);
        Pointer retCnt = new Pointer(4);
        status = viBufReadFn.call4(vi, bytes, cnt, retCnt);
        switch (status) {
            case 1073676293: 
            case 1073676294: {
                status = 0;
                break;
            }
            default: {
                Visa.assertCleanStatus("viBufRead");
            }
        }
        byte[] toReturn = new byte[cnt];
        bytes.getBytes(0L, toReturn, 0, cnt);
        bytes.free();
        return toReturn;
    }

    public static synchronized int viBufWrite(int vi, byte[] buf, int cnt) throws VisaException {
        Pointer string = new Pointer(buf.length);
        string.setBytes(0L, buf, 0, buf.length);
        status = viBufWriteFn.call4(vi, string, cnt, pValue.getPointer());
        Visa.assertCleanStatus("viBufWrite");
        string.free();
        return pValue.getValue();
    }

    public static void viFlush(int vi, short mask) throws VisaException {
        status = viFlushFn.call2(vi, (int)mask);
        Visa.assertCleanStatus("viFlush");
    }

    public static void viClear(int vi) throws VisaException {
        viClearFn.call1(vi);
        Visa.assertCleanStatus("viClear");
    }

    protected static final void assertCleanStatus(String function) throws VisaException {
        if (status < 0) {
            throw new VisaException(function, status);
        }
        if (status != 0) {
            System.out.println(VisaException.makeMessage(function, status));
            status = 0;
        }
    }

    private Visa() {
    }

    static {
        pValue = new IntByReference(0);
        viOpenDefaultRMFn = NativeLibrary.getDefaultInstance().getFunction("viOpenDefaultRM");
        viOpenFn = NativeLibrary.getDefaultInstance().getFunction("viOpen");
        viSetAttributeFn = NativeLibrary.getDefaultInstance().getFunction("viSetAttribute");
        viSetBufFn = NativeLibrary.getDefaultInstance().getFunction("viSetBuf");
        viCloseFn = NativeLibrary.getDefaultInstance().getFunction("viClose");
        viGetAttributeFn = NativeLibrary.getDefaultInstance().getFunction("viGetAttribute");
        viVPrintfFn = NativeLibrary.getDefaultInstance().getFunction("viVPrintf");
        viBufReadFn = NativeLibrary.getDefaultInstance().getFunction("viBufRead");
        viBufWriteFn = NativeLibrary.getDefaultInstance().getFunction("viBufWrite");
        viFlushFn = NativeLibrary.getDefaultInstance().getFunction("viFlush");
        viClearFn = NativeLibrary.getDefaultInstance().getFunction("viClear");
    }
}

