/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ros.exception.RosMessageRuntimeException;
import org.ros.internal.message.DefaultMessageFactory;
import org.ros.internal.message.MessageInterfaceBuilder;
import org.ros.internal.message.definition.MessageDefinitionProviderChain;
import org.ros.internal.message.definition.MessageDefinitionTupleParser;
import org.ros.internal.message.service.ServiceDefinitionFileProvider;
import org.ros.internal.message.topic.TopicDefinitionFileProvider;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageFactory;
import org.ros.message.MessageIdentifier;

public class GenerateInterfaces {
    private final TopicDefinitionFileProvider topicDefinitionFileProvider;
    private final ServiceDefinitionFileProvider serviceDefinitionFileProvider;
    private final MessageDefinitionProviderChain messageDefinitionProviderChain = new MessageDefinitionProviderChain();
    private final MessageFactory messageFactory;
    private static final String ROS_PACKAGE_PATH = "ROS_PACKAGE_PATH";

    public GenerateInterfaces() {
        this.topicDefinitionFileProvider = new TopicDefinitionFileProvider();
        this.messageDefinitionProviderChain.addMessageDefinitionProvider(this.topicDefinitionFileProvider);
        this.serviceDefinitionFileProvider = new ServiceDefinitionFileProvider();
        this.messageDefinitionProviderChain.addMessageDefinitionProvider(this.serviceDefinitionFileProvider);
        this.messageFactory = new DefaultMessageFactory(this.messageDefinitionProviderChain);
    }

    private void writeTopicInterfaces(File outputDirectory, Collection<String> packages) throws IOException {
        HashSet topicTypes = Sets.newHashSet();
        if (packages.size() == 0) {
            packages = this.topicDefinitionFileProvider.getPackages();
        }
        for (String pkg : packages) {
            System.out.println("Package: " + pkg);
            Collection<MessageIdentifier> messageIdentifiers = this.topicDefinitionFileProvider.getMessageIdentifiersByPackage(pkg);
            if (messageIdentifiers == null) continue;
            topicTypes.addAll(messageIdentifiers);
        }
        for (MessageIdentifier topicType : topicTypes) {
            String definition = this.messageDefinitionProviderChain.get(topicType.getType());
            MessageDeclaration messageDeclaration = new MessageDeclaration(topicType, definition);
            this.writeInterface(messageDeclaration, outputDirectory, true);
        }
    }

    private void writeServiceInterfaces(File outputDirectory, Collection<String> packages) throws IOException {
        HashSet serviceTypes = Sets.newHashSet();
        if (packages.size() == 0) {
            packages = this.serviceDefinitionFileProvider.getPackages();
        }
        for (String pkg : packages) {
            Collection<MessageIdentifier> messageIdentifiers = this.serviceDefinitionFileProvider.getMessageIdentifiersByPackage(pkg);
            if (messageIdentifiers == null) continue;
            serviceTypes.addAll(messageIdentifiers);
        }
        for (MessageIdentifier serviceType : serviceTypes) {
            String definition = this.messageDefinitionProviderChain.get(serviceType.getType());
            MessageDeclaration serviceDeclaration = MessageDeclaration.of(serviceType.getType(), definition);
            this.writeInterface(serviceDeclaration, outputDirectory, false);
            List<String> requestAndResponse = MessageDefinitionTupleParser.parse(definition, 2);
            MessageDeclaration requestDeclaration = MessageDeclaration.of(serviceType.getType() + "Request", requestAndResponse.get(0));
            MessageDeclaration responseDeclaration = MessageDeclaration.of(serviceType.getType() + "Response", requestAndResponse.get(1));
            this.writeInterface(requestDeclaration, outputDirectory, true);
            this.writeInterface(responseDeclaration, outputDirectory, true);
        }
    }

    private void writeInterface(MessageDeclaration messageDeclaration, File outputDirectory, boolean addConstantsAndMethods) {
        MessageInterfaceBuilder builder = new MessageInterfaceBuilder();
        builder.setPackageName(messageDeclaration.getPackage());
        builder.setInterfaceName(messageDeclaration.getName());
        builder.setMessageDeclaration(messageDeclaration);
        builder.setAddConstantsAndMethods(addConstantsAndMethods);
        try {
            String content = builder.build(this.messageFactory);
            File file = new File(outputDirectory, messageDeclaration.getType() + ".java");
            FileUtils.writeStringToFile((File)file, (String)content);
        }
        catch (Exception e) {
            System.out.printf("Failed to generate interface for %s.\n", messageDeclaration.getType());
            e.printStackTrace();
        }
    }

    public void generate(File outputDirectory, Collection<String> packages, Collection<File> packagePath) {
        for (File directory : packagePath) {
            this.topicDefinitionFileProvider.addDirectory(directory);
            this.serviceDefinitionFileProvider.addDirectory(directory);
        }
        this.topicDefinitionFileProvider.update();
        this.serviceDefinitionFileProvider.update();
        try {
            this.writeTopicInterfaces(outputDirectory, packages);
            this.writeServiceInterfaces(outputDirectory, packages);
        }
        catch (IOException e) {
            throw new RosMessageRuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ArrayList arguments = Lists.newArrayList((Object[])args);
        if (arguments.size() == 0) {
            arguments.add(".");
        }
        String rosPackagePath = System.getenv(ROS_PACKAGE_PATH);
        ArrayList packagePath = Lists.newArrayList();
        for (String path : rosPackagePath.split(File.pathSeparator)) {
            File packageDirectory = new File(path);
            if (!packageDirectory.exists()) continue;
            packagePath.add(packageDirectory);
        }
        GenerateInterfaces generateInterfaces = new GenerateInterfaces();
        File outputDirectory = new File((String)arguments.remove(0));
        generateInterfaces.generate(outputDirectory, arguments, packagePath);
    }
}

