/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ros.internal.message.field.FieldFactory;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageFactory;
import org.ros.message.MessageIdentifier;

public class MessageContext {
    private final MessageDeclaration messageDeclaration;
    private final MessageFactory messageFactory;
    private final Map<String, FieldFactory> fieldFactories;
    private final Map<String, String> fieldGetterNames;
    private final Map<String, String> fieldSetterNames;
    private final List<String> fieldNames;

    public MessageContext(MessageDeclaration messageDeclaration, MessageFactory messageFactory) {
        this.messageDeclaration = messageDeclaration;
        this.messageFactory = messageFactory;
        this.fieldFactories = Maps.newHashMap();
        this.fieldGetterNames = Maps.newHashMap();
        this.fieldSetterNames = Maps.newHashMap();
        this.fieldNames = Lists.newArrayList();
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public MessageIdentifier getMessageIdentifer() {
        return this.messageDeclaration.getMessageIdentifier();
    }

    public String getType() {
        return this.messageDeclaration.getType();
    }

    public String getPackage() {
        return this.messageDeclaration.getPackage();
    }

    public String getName() {
        return this.messageDeclaration.getName();
    }

    public String getDefinition() {
        return this.messageDeclaration.getDefinition();
    }

    public void addFieldFactory(String name, FieldFactory fieldFactory) {
        this.fieldFactories.put(name, fieldFactory);
        this.fieldGetterNames.put(name, "get" + this.getJavaName(name));
        this.fieldSetterNames.put(name, "set" + this.getJavaName(name));
        this.fieldNames.add(name);
    }

    private String getJavaName(String name) {
        String[] parts = name.split("_");
        StringBuilder fieldName = new StringBuilder();
        for (String part : parts) {
            fieldName.append(part.substring(0, 1).toUpperCase() + part.substring(1));
        }
        return fieldName.toString();
    }

    public boolean hasField(String name) {
        return this.fieldFactories.containsKey(name);
    }

    public String getFieldGetterName(String name) {
        return this.fieldGetterNames.get(name);
    }

    public String getFieldSetterName(String name) {
        return this.fieldSetterNames.get(name);
    }

    public FieldFactory getFieldFactory(String name) {
        return this.fieldFactories.get(name);
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageDeclaration == null ? 0 : this.messageDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageContext other = (MessageContext)obj;
        return !(this.messageDeclaration == null ? other.messageDeclaration != null : !this.messageDeclaration.equals(other.messageDeclaration));
    }
}

