/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.definition;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.ros.internal.message.StringFileProvider;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageIdentifier;

public class MessageDefinitionFileProvider
implements MessageDefinitionProvider {
    private final StringFileProvider stringFileProvider;
    private final Map<String, Collection<MessageIdentifier>> messageIdentifiers;
    private final Map<String, String> definitions;

    public MessageDefinitionFileProvider(StringFileProvider stringFileProvider) {
        this.stringFileProvider = stringFileProvider;
        this.messageIdentifiers = Maps.newConcurrentMap();
        this.definitions = Maps.newConcurrentMap();
    }

    private static String getParent(String filename) {
        return FilenameUtils.getFullPathNoEndSeparator((String)filename);
    }

    protected static String getParentBaseName(String filename) {
        return FilenameUtils.getBaseName((String)MessageDefinitionFileProvider.getParent(filename));
    }

    private static MessageIdentifier fileToMessageIdentifier(File file) {
        String filename = file.getAbsolutePath();
        String name = FilenameUtils.getBaseName((String)filename);
        String pkg = MessageDefinitionFileProvider.getParentBaseName(MessageDefinitionFileProvider.getParent(filename));
        return MessageIdentifier.of(pkg, name);
    }

    private void addDefinition(File file, String definition) {
        MessageIdentifier topicType = MessageDefinitionFileProvider.fileToMessageIdentifier(file);
        if (this.definitions.containsKey(topicType.getType())) {
            return;
        }
        this.definitions.put(topicType.getType(), definition);
        if (!this.messageIdentifiers.containsKey(topicType.getPackage())) {
            this.messageIdentifiers.put(topicType.getPackage(), new HashSet());
        }
        this.messageIdentifiers.get(topicType.getPackage()).add(topicType);
    }

    public void update() {
        this.stringFileProvider.update();
        for (Map.Entry<File, String> entry : this.stringFileProvider.getStrings().entrySet()) {
            this.addDefinition(entry.getKey(), entry.getValue());
        }
    }

    public void addDirectory(File directory) {
        this.stringFileProvider.addDirectory(directory);
    }

    @Override
    public Collection<String> getPackages() {
        return this.messageIdentifiers.keySet();
    }

    @Override
    public Collection<MessageIdentifier> getMessageIdentifiersByPackage(String pkg) {
        return this.messageIdentifiers.get(pkg);
    }

    @Override
    public String get(String type) {
        return this.definitions.get(type);
    }

    @Override
    public boolean has(String type) {
        return this.definitions.containsKey(type);
    }
}

