/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.ros.exception.RosMessageRuntimeException;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageIdentifier;

public class MessageDefinitionReflectionProvider
implements MessageDefinitionProvider {
    private static final String DEFINITION_FIELD = "_DEFINITION";
    private final Map<String, String> cache = Maps.newConcurrentMap();

    @Override
    public String get(String messageType) {
        String messageDefinition = this.cache.get(messageType);
        if (messageDefinition == null) {
            String className = messageType.replace("/", ".");
            try {
                Class<?> loadedClass = this.getClass().getClassLoader().loadClass(className);
                messageDefinition = (String)loadedClass.getDeclaredField(DEFINITION_FIELD).get(null);
                this.cache.put(messageType, messageDefinition);
            }
            catch (Exception e) {
                throw new RosMessageRuntimeException(e);
            }
        }
        return messageDefinition;
    }

    @Override
    public boolean has(String messageType) {
        try {
            this.get(messageType);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getPackages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<MessageIdentifier> getMessageIdentifiersByPackage(String pkg) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    public void add(String messageType, String messageDefinition) {
        this.cache.put(messageType, messageDefinition);
    }
}

