/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.definition;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class MessageDefinitionTupleParser {
    private static final String SEPARATOR = "---";

    public static List<String> parse(String definition, int size) {
        Preconditions.checkNotNull((Object)definition);
        ArrayList definitions = Lists.newArrayList();
        StringBuilder current = new StringBuilder();
        for (String line : definition.split("\n")) {
            if (line.startsWith(SEPARATOR)) {
                definitions.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(line);
            current.append("\n");
        }
        if (current.length() > 0) {
            current.deleteCharAt(current.length() - 1);
        }
        definitions.add(current.toString());
        Preconditions.checkState((size == -1 || definitions.size() <= size ? 1 : 0) != 0, (Object)String.format("Message tuple exceeds expected size: %d > %d", definitions.size(), size));
        while (definitions.size() < size) {
            definitions.add("");
        }
        return definitions;
    }
}

