/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.DefaultMessageDeserializer;
import org.ros.internal.message.DefaultMessageSerializer;
import org.ros.internal.message.Message;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;
import org.ros.internal.message.field.ListField;
import org.ros.internal.message.field.ValueField;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageIdentifier;
import org.ros.message.MessageSerializer;

public class MessageFieldType
implements FieldType {
    private final MessageIdentifier messageIdentifier;
    private final MessageFactory messageFactory;
    private final MessageSerializer<Message> serializer;
    private final MessageDeserializer<Message> deserializer;

    public MessageFieldType(MessageIdentifier messageIdentifier, MessageFactory messageFactory) {
        this.messageIdentifier = messageIdentifier;
        this.messageFactory = messageFactory;
        this.serializer = new DefaultMessageSerializer();
        this.deserializer = new DefaultMessageDeserializer<Message>(messageIdentifier, messageFactory);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public Field newVariableValue(String name) {
        return ValueField.newVariable(this, name);
    }

    @Override
    public <T> Field newConstantValue(String name, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Field newVariableList(String name, int size) {
        return ListField.newVariable(this, name);
    }

    @Override
    public <T> T getDefaultValue() {
        return this.getMessageFactory().newFromType(this.messageIdentifier.getType());
    }

    @Override
    public String getMd5String() {
        return null;
    }

    @Override
    public String getJavaTypeName() {
        return String.format("%s.%s", this.messageIdentifier.getPackage(), this.messageIdentifier.getName());
    }

    @Override
    public int getSerializedSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.messageIdentifier.getType();
    }

    @Override
    public <T> void serialize(T value, ChannelBuffer buffer) {
        this.serializer.serialize((Message)value, buffer);
    }

    public Message deserialize(ChannelBuffer buffer) {
        return this.deserializer.deserialize(buffer);
    }

    public Void parseFromString(String value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "MessageField<" + this.messageIdentifier + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageIdentifier == null ? 0 : this.messageIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFieldType other = (MessageFieldType)obj;
        return !(this.messageIdentifier == null ? other.messageIdentifier != null : !this.messageIdentifier.equals(other.messageIdentifier));
    }
}

